/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.membranechannels.model;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.membranechannels.model.BoundedLinearMotionStrategy;
import edu.colorado.phet.membranechannels.model.IMovable;
import edu.colorado.phet.membranechannels.model.MembraneChannel;
import edu.colorado.phet.membranechannels.model.MotionStrategy;
import edu.colorado.phet.membranechannels.model.RandomWalkMotionStrategy;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TraverseChannelMotionStrategy
extends MotionStrategy {
    private static final Random RAND = new Random();
    private Vector2D velocityVector = new Vector2D();
    private ArrayList<Point2D> traversalPoints;
    private int currentDestinationIndex = 0;
    private boolean channelHasBeenEntered = false;
    private boolean channelHasBeenTraversed = false;
    private double velocityScaler;
    protected final MembraneChannel channel;
    private Rectangle2D preTraversalMotionBounds = new Rectangle2D.Double();
    private Rectangle2D postTraversalMotionBounds = new Rectangle2D.Double();
    private MotionStrategy postTraversalMotionStrategy;
    private double postTraversalCountdownTimer = Double.POSITIVE_INFINITY;

    public TraverseChannelMotionStrategy(MembraneChannel membraneChannel, Point2D point2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, double d) {
        this.channel = membraneChannel;
        this.velocityScaler = d;
        this.preTraversalMotionBounds.setFrame(rectangle2D);
        this.postTraversalMotionBounds.setFrame(rectangle2D2);
        this.traversalPoints = this.createTraversalPoints(membraneChannel, point2D);
        this.currentDestinationIndex = 0;
        this.setCourseForCurrentTraversalPoint(point2D);
    }

    @Override
    public void move(IMovable iMovable, double d) {
        Point2D point2D = iMovable.getPositionReference();
        if (!this.channelHasBeenEntered) {
            this.channelHasBeenEntered = this.channel.isPointInChannel(point2D);
        }
        if (this.channelHasBeenTraversed) {
            this.postTraversalCountdownTimer -= d;
            if (this.postTraversalCountdownTimer <= 0.0) {
                this.notifyStrategyComplete(iMovable);
                iMovable.setMotionStrategy(new RandomWalkMotionStrategy(this.postTraversalMotionBounds));
            } else {
                this.postTraversalMotionStrategy.move(iMovable, d);
            }
        } else if (this.channel.isOpen() || this.channelHasBeenEntered) {
            if (this.currentDestinationIndex >= this.traversalPoints.size() || this.velocityScaler * d < point2D.distance(this.traversalPoints.get(this.currentDestinationIndex))) {
                iMovable.setPosition(point2D.getX() + this.velocityVector.getX() * d, point2D.getY() + this.velocityVector.getY() * d);
            } else {
                iMovable.setPosition(this.traversalPoints.get(this.currentDestinationIndex));
                ++this.currentDestinationIndex;
                this.setCourseForCurrentTraversalPoint(iMovable.getPosition());
                if (this.currentDestinationIndex == this.traversalPoints.size()) {
                    this.channelHasBeenTraversed = true;
                    double d2 = 1.5707963267948966 + (RAND.nextDouble() - 0.5) * Math.PI * 0.75;
                    if (this.getInstantaneousVelocity().getAngle() < 0.0) {
                        d2 = -d2;
                    }
                    Vector2D vector2D = new Vector2D();
                    vector2D.setMagnitudeAndAngle(this.velocityScaler, d2);
                    this.postTraversalMotionStrategy = new BoundedLinearMotionStrategy(vector2D, this.postTraversalMotionBounds);
                    this.postTraversalCountdownTimer = 1.0;
                }
            }
        } else {
            iMovable.setMotionStrategy(new RandomWalkMotionStrategy(this.preTraversalMotionBounds));
            this.notifyStrategyComplete(iMovable);
        }
    }

    @Override
    public Vector2D getInstantaneousVelocity() {
        return new Vector2D(this.velocityVector.getX(), this.velocityVector.getY());
    }

    public void abortTraversal(IMovable iMovable) {
        Point2D point2D = iMovable.getPositionReference();
        if (this.preTraversalMotionBounds.contains(point2D)) {
            iMovable.setMotionStrategy(new RandomWalkMotionStrategy(this.preTraversalMotionBounds));
        } else if (this.postTraversalMotionBounds.contains(point2D)) {
            iMovable.setMotionStrategy(new RandomWalkMotionStrategy(this.postTraversalMotionBounds));
        } else {
            iMovable.setPosition(this.traversalPoints.get(this.traversalPoints.size() - 1));
            iMovable.setMotionStrategy(new RandomWalkMotionStrategy(this.postTraversalMotionBounds));
        }
    }

    private ArrayList<Point2D> createTraversalPoints(MembraneChannel membraneChannel, Point2D point2D) {
        ArrayList<Point2D> arrayList = new ArrayList<Point2D>();
        Point2D point2D2 = membraneChannel.getCenterLocation();
        double d = membraneChannel.getChannelSize().getHeight() * 0.7;
        Point2D.Double double_ = new Point2D.Double(point2D2.getX(), point2D2.getY() + d);
        Point2D.Double double_2 = new Point2D.Double(point2D2.getX(), point2D2.getY() - d);
        if (point2D.distance(double_2) < point2D.distance(double_)) {
            arrayList.add(double_2);
            arrayList.add(double_);
        } else {
            arrayList.add(double_);
            arrayList.add(double_2);
        }
        return arrayList;
    }

    private void setCourseForCurrentTraversalPoint(Point2D point2D) {
        if (this.currentDestinationIndex < this.traversalPoints.size()) {
            Point2D point2D2 = this.traversalPoints.get(this.currentDestinationIndex);
            this.velocityVector.setComponents(point2D2.getX() - point2D.getX(), point2D2.getY() - point2D.getY());
            double d = this.velocityScaler / this.velocityVector.getMagnitude();
            this.velocityVector.scale(d);
        } else {
            this.velocityVector.rotate((RAND.nextDouble() - 0.5) * Math.PI * 0.9);
        }
    }
}

