/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.membranechannels.model;

import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.membranechannels.model.MembraneChannelOpennessStrategy;

public class TimedSettableOpennessStrategy
extends MembraneChannelOpennessStrategy {
    private double targetOpennessValue = 0.0;

    public TimedSettableOpennessStrategy(ConstantDtClock constantDtClock) {
        super(constantDtClock);
    }

    public TimedSettableOpennessStrategy(double d) {
        assert (d >= 0.0 && d <= 1.0);
        this.setOpenness(d);
        this.targetOpennessValue = d;
    }

    public void open() {
        this.targetOpennessValue = 1.0;
    }

    public void close() {
        this.targetOpennessValue = 0.0;
    }

    public void stepInTime(double d) {
        if (this.getOpenness() < this.targetOpennessValue) {
            this.setOpenness(Math.min(this.getOpenness() + 4.0 * d, this.targetOpennessValue));
        } else if (this.getOpenness() > this.targetOpennessValue) {
            this.setOpenness(Math.max(this.getOpenness() - 4.0 * d, this.targetOpennessValue));
        }
    }

    protected boolean isDynamic() {
        return true;
    }
}

