/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.membranechannels.model;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.membranechannels.model.IMovable;
import edu.colorado.phet.membranechannels.model.MotionStrategy;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Random;

public class RandomWalkMotionStrategy
extends MotionStrategy {
    private static final Random RAND = new Random();
    private double timeUntilNextVelocityChange;
    private Vector2D velocityVector = new Vector2D(0.0, 0.0);
    private Point2D currentLocation = new Point2D.Double();
    private Rectangle2D motionBounds = new Rectangle2D.Double();

    public RandomWalkMotionStrategy(Rectangle2D rectangle2D) {
        this.motionBounds.setFrame(rectangle2D.getMinX(), rectangle2D.getMinY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        this.timeUntilNextVelocityChange = this.generateNewVelocityChangeTime();
        this.changeVelocityVector();
    }

    public void move(IMovable iMovable, double d) {
        this.currentLocation.setLocation(iMovable.getPositionReference());
        double d2 = iMovable.getRadius();
        if (this.currentLocation.getX() + d2 > this.motionBounds.getMaxX() && this.velocityVector.getX() > 0.0 || this.currentLocation.getX() - d2 < this.motionBounds.getMinX() && this.velocityVector.getX() < 0.0) {
            this.velocityVector.setComponents(-this.velocityVector.getX(), this.velocityVector.getY());
        }
        if (this.currentLocation.getY() + d2 > this.motionBounds.getMaxY() && this.velocityVector.getY() > 0.0 || this.currentLocation.getY() - d2 < this.motionBounds.getMinY() && this.velocityVector.getY() < 0.0) {
            this.velocityVector.setComponents(this.velocityVector.getX(), -this.velocityVector.getY());
        }
        this.currentLocation.setLocation(this.currentLocation.getX() + this.velocityVector.getX() * d, this.currentLocation.getY() + this.velocityVector.getY() * d);
        iMovable.setPosition(this.currentLocation);
        this.timeUntilNextVelocityChange -= d;
        if (this.timeUntilNextVelocityChange <= 0.0) {
            this.changeVelocityVector();
            this.timeUntilNextVelocityChange = this.generateNewVelocityChangeTime();
        }
    }

    public Vector2D getInstantaneousVelocity() {
        return new Vector2D(this.velocityVector.getX(), this.velocityVector.getY());
    }

    private double generateNewVelocityChangeTime() {
        return 0.2 + RAND.nextDouble() * 0.8;
    }

    private void changeVelocityVector() {
        double d = RAND.nextDouble() * Math.PI * 2.0;
        double d2 = 10.0 + RAND.nextDouble() * 4.0;
        this.velocityVector.setComponents(d2 * Math.cos(d), d2 * Math.sin(d));
    }
}

