/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.mazegame;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.mazegame.BarrierList;
import edu.colorado.phet.mazegame.ControlBoxPanel;
import edu.colorado.phet.mazegame.MazeGameResources;
import edu.colorado.phet.mazegame.MazeGameSimulationPanel;
import edu.colorado.phet.mazegame.Particle;
import edu.colorado.phet.mazegame.PositionUpdater;
import edu.colorado.phet.mazegame.ScorePanel;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class ParticleArena
extends JPanel
implements Runnable {
    private MazeGameSimulationPanel mazeGUI1;
    private ScorePanel scrPanel;
    private Particle myParticle;
    private int radius;
    private int barrierState;
    private Color barrierColor;
    private boolean collisionDetected;
    private boolean goalDetected;
    private int nbrCollisions;
    private int lastX;
    private int lastY;
    private int collisionX;
    private int collisionY;
    boolean setToPlayTada = true;
    private int goalX = MazeGameSimulationPanel.fullWidth / 8;
    private int goalY = 3 * MazeGameSimulationPanel.fullHeight / 8;
    private ControlBoxPanel cbPanel;
    private PositionUpdater pUpdater;
    private Thread myThread;
    private int timeStep = 30;
    private double positionFactor = 1.5;
    private double vTimeStep = 0.001 * (double)this.timeStep;
    private double aTimeStep = 0.001 * (double)this.timeStep;
    private Border raisedBevel;
    private Border compound2;
    private Font arenaFont = new PhetFont(25, true);

    public ParticleArena(MazeGameSimulationPanel mazeGameSimulationPanel) {
        this.mazeGUI1 = mazeGameSimulationPanel;
        this.setBackground(new Color(255, 232, 45));
        this.barrierColor = new Color(50, 50, 250);
        this.raisedBevel = BorderFactory.createRaisedBevelBorder();
        this.compound2 = BorderFactory.createTitledBorder(this.raisedBevel, MazeGameResources.getString("ParticleArena.ArenaBorder"), 2, 4);
        this.setBorder(this.compound2);
        this.collisionDetected = false;
        this.goalDetected = false;
        this.nbrCollisions = 0;
        this.cbPanel = new ControlBoxPanel(this);
        this.scrPanel = new ScorePanel(this, this.cbPanel);
        this.pUpdater = new PositionUpdater(this.positionFactor * this.cbPanel.getDeltaX() + (double)(MazeGameSimulationPanel.fullWidth / 2), this.positionFactor * this.cbPanel.getDeltaY() + (double)(MazeGameSimulationPanel.fullHeight / 4));
        this.myParticle = new Particle(this.pUpdater.getX(), this.pUpdater.getY());
        this.radius = this.myParticle.getRadius();
    }

    public void start() {
        if (this.myThread == null) {
            this.myThread = new Thread(this);
            this.myThread.start();
        }
    }

    public void stop() {
        if (this.myThread != null) {
            this.myThread = null;
        }
    }

    public void run() {
        Thread thread = Thread.currentThread();
        while (this.myThread == thread) {
            double d;
            double d2;
            if (this.cbPanel.getControlState() == ControlBoxPanel.POSITION) {
                d2 = this.positionFactor * this.cbPanel.getDeltaX() + (double)(MazeGameSimulationPanel.fullWidth / 2);
                d = this.positionFactor * this.cbPanel.getDeltaY() + (double)(MazeGameSimulationPanel.fullHeight / 4);
                if (this.pUpdater != null) {
                    this.pUpdater.updateWithPos(d2, d);
                }
            }
            if (this.cbPanel.getControlState() == ControlBoxPanel.VELOCITY) {
                d2 = this.cbPanel.getDeltaX();
                d = this.cbPanel.getDeltaY();
                this.pUpdater.updateWithVel(d2, d, this.vTimeStep);
            }
            if (this.cbPanel.getControlState() == ControlBoxPanel.ACCELERATION) {
                d2 = this.cbPanel.getDeltaX();
                d = this.cbPanel.getDeltaY();
                this.pUpdater.updateWithAcc(d2, d, this.aTimeStep);
            }
            this.myParticle.setXY(this.pUpdater.getIntX(), this.pUpdater.getIntY());
            int n = (int)this.myParticle.getX();
            int n2 = (int)this.myParticle.getY();
            int n3 = 20;
            if (n > 0 && n < MazeGameSimulationPanel.fullWidth && n2 > 0 && n2 < MazeGameSimulationPanel.fullHeight / 2) {
                if (BarrierList.currentCollisionArray[n][n2] == 0 && !this.collisionDetected) {
                    this.lastX = n;
                    this.lastY = n2;
                } else if (BarrierList.currentCollisionArray[n][n2] > 0 && !this.collisionDetected) {
                    this.collisionDetected = true;
                    this.collisionX = this.lastX;
                    this.collisionY = this.lastY;
                    ++this.nbrCollisions;
                    this.scrPanel.nbrCollisionsLbl.setText(new Integer(this.nbrCollisions).toString());
                    if (this.mazeGUI1.cork != null && this.scrPanel.soundOn) {
                        this.mazeGUI1.cork.play();
                    }
                } else if (BarrierList.currentCollisionArray[n][n2] == 0 && this.collisionDetected) {
                    if (n < this.collisionX + n3 && n > this.collisionX - n3 && n2 < this.collisionY + n3 && n2 > this.collisionY - n3) {
                        this.collisionDetected = false;
                        this.lastX = n;
                        this.lastY = n2;
                    } else {
                        this.collisionDetected = true;
                    }
                }
            }
            if (n < this.goalX + this.radius && n > this.goalX - this.radius && n2 < this.goalY + this.radius && n2 > this.goalY - this.radius) {
                if (this.setToPlayTada && !this.collisionDetected) {
                    if (this.mazeGUI1.figaro != null && this.scrPanel.soundOn) {
                        this.mazeGUI1.figaro.play();
                    }
                    this.goalDetected = true;
                    this.scrPanel.myClock1.stop();
                    double d3 = this.scrPanel.myClock1.getTime();
                    double d4 = d3 + (double)(5 * this.nbrCollisions);
                    this.scrPanel.ptsScoreLbl.setText(new Double(d4).toString());
                    this.setToPlayTada = false;
                } else {
                    this.goalDetected = true;
                }
            } else {
                this.goalDetected = false;
                this.setToPlayTada = true;
            }
            this.repaint();
            try {
                Thread.sleep(this.timeStep);
            }
            catch (Exception exception) {}
        }
    }

    public ControlBoxPanel getControlBoxPanel() {
        return this.cbPanel;
    }

    public ScorePanel getScorePanel() {
        return this.scrPanel;
    }

    public void setBarrierState(int n) {
        this.barrierState = n;
        switch (this.barrierState) {
            case 0: {
                BarrierList.currentCollisionArray = BarrierList.collisionArray0;
                break;
            }
            case 1: {
                BarrierList.currentCollisionArray = BarrierList.collisionArray1;
                break;
            }
            case 2: {
                BarrierList.currentCollisionArray = BarrierList.collisionArray2;
                break;
            }
            case 3: {
                BarrierList.currentCollisionArray = BarrierList.collisionArray3;
            }
        }
        this.repaint();
    }

    public double getPositionFactor() {
        return this.positionFactor;
    }

    public void setCollisionDetected(boolean bl) {
        this.collisionDetected = bl;
    }

    public void setGoalDetected(boolean bl) {
        this.goalDetected = bl;
    }

    public void setNbrCollisions(int n) {
        this.nbrCollisions = n;
    }

    public double getCurrentX() {
        return this.myParticle.getX();
    }

    public double getCurrentY() {
        return this.myParticle.getY();
    }

    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        super.paintComponent(graphics);
        graphics.setColor(this.barrierColor);
        for (int i = 0; i < BarrierList.currentRectArray[this.barrierState].length; ++i) {
            int n = BarrierList.currentRectArray[this.barrierState][i].x;
            int n2 = BarrierList.currentRectArray[this.barrierState][i].y;
            int n3 = BarrierList.currentRectArray[this.barrierState][i].width;
            int n4 = BarrierList.currentRectArray[this.barrierState][i].height;
            graphics.fill3DRect(n, n2, n3, n4, false);
        }
        if (this.collisionDetected) {
            graphics.drawImage(this.mazeGUI1.splat, this.collisionX - 15, this.collisionY - 15, this);
            graphics.setColor(Color.red);
            graphics.setFont(this.arenaFont);
            graphics.drawString(MazeGameResources.getString("ParticleArena.CollisionText"), MazeGameSimulationPanel.fullWidth / 2, 7 * MazeGameSimulationPanel.fullHeight / 16);
        }
        if (this.goalDetected && !this.collisionDetected) {
            graphics.setColor(Color.blue);
            graphics.setFont(this.arenaFont);
            graphics.drawString(MazeGameResources.getString("ParticleArena.GoalText"), MazeGameSimulationPanel.fullWidth / 10, 11 * MazeGameSimulationPanel.fullHeight / 32);
        }
        if (this.goalDetected && this.collisionDetected) {
            graphics.setColor(Color.red);
            graphics.setFont(this.arenaFont);
            graphics.drawString(MazeGameResources.getString("ParticleArena.NoGoalText"), MazeGameSimulationPanel.fullWidth / 12, 11 * MazeGameSimulationPanel.fullHeight / 32);
        }
        graphics.fillOval(this.goalX - this.radius, this.goalY - this.radius, 2 * this.radius, 2 * this.radius);
        graphics.setFont(new PhetFont(15, true));
        graphics.drawString(MazeGameResources.getString("ParticleArena.FinishText"), this.goalX - 2 * this.radius, this.goalY + 25);
        graphics.drawImage(this.mazeGUI1.ballImage, (int)this.myParticle.getX() - this.radius, (int)this.myParticle.getY() - this.radius, this);
    }
}

