/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.linegraphing.slopeintercept.view;

import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentTypes;
import edu.colorado.phet.common.phetcommon.util.RichSimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.linegraphing.common.LGColors;
import edu.colorado.phet.linegraphing.common.LGSimSharing;
import edu.colorado.phet.linegraphing.common.model.Graph;
import edu.colorado.phet.linegraphing.common.model.Line;
import edu.colorado.phet.linegraphing.common.view.LineFormsGraphNode;
import edu.colorado.phet.linegraphing.common.view.LineFormsViewProperties;
import edu.colorado.phet.linegraphing.common.view.LineNode;
import edu.colorado.phet.linegraphing.common.view.manipulator.LineManipulatorNode;
import edu.colorado.phet.linegraphing.common.view.manipulator.SlopeDragHandler;
import edu.colorado.phet.linegraphing.common.view.manipulator.YInterceptDragHandler;
import edu.colorado.phet.linegraphing.slopeintercept.model.SlopeInterceptModel;
import edu.colorado.phet.linegraphing.slopeintercept.view.SlopeInterceptLineNode;
import java.awt.geom.Point2D;

public class SlopeInterceptGraphNode
extends LineFormsGraphNode {
    private final LineManipulatorNode interceptManipulatorNode;
    private final LineManipulatorNode slopeManipulatorNode = new LineManipulatorNode(this.getManipulatorDiameter(), LGColors.SLOPE);

    public SlopeInterceptGraphNode(final SlopeInterceptModel slopeInterceptModel, final LineFormsViewProperties lineFormsViewProperties) {
        super(slopeInterceptModel, lineFormsViewProperties);
        this.slopeManipulatorNode.addInputEventListener(new SlopeDragHandler(LGSimSharing.UserComponents.slopeManipulator, UserComponentTypes.sprite, this.slopeManipulatorNode, slopeInterceptModel.mvt, slopeInterceptModel.interactiveLine, slopeInterceptModel.riseRange, slopeInterceptModel.runRange));
        this.interceptManipulatorNode = new LineManipulatorNode(this.getManipulatorDiameter(), LGColors.INTERCEPT);
        this.interceptManipulatorNode.addInputEventListener(new YInterceptDragHandler(LGSimSharing.UserComponents.interceptManipulator, UserComponentTypes.sprite, this.interceptManipulatorNode, slopeInterceptModel.mvt, slopeInterceptModel.interactiveLine, slopeInterceptModel.y1Range));
        this.addChild(this.slopeManipulatorNode);
        this.addChild(this.interceptManipulatorNode);
        slopeInterceptModel.interactiveLine.addObserver(new VoidFunction1<Line>(){

            @Override
            public void apply(Line line) {
                SlopeInterceptGraphNode.this.slopeManipulatorNode.setOffset(slopeInterceptModel.mvt.modelToView(new Point2D.Double(line.x1 + line.run, line.y1 + line.rise)));
                SlopeInterceptGraphNode.this.interceptManipulatorNode.setOffset(slopeInterceptModel.mvt.modelToView(new Point2D.Double(line.x1, line.y1)));
            }
        });
        RichSimpleObserver richSimpleObserver = new RichSimpleObserver(){

            public void update() {
                boolean bl = lineFormsViewProperties.linesVisible.get() != false && lineFormsViewProperties.interactiveLineVisible.get() != false;
                SlopeInterceptGraphNode.this.slopeManipulatorNode.setVisible(bl);
                SlopeInterceptGraphNode.this.interceptManipulatorNode.setVisible(bl);
            }
        };
        richSimpleObserver.observe(lineFormsViewProperties.linesVisible, lineFormsViewProperties.interactiveLineVisible);
    }

    protected LineNode createLineNode(Line line, Graph graph, ModelViewTransform modelViewTransform) {
        return new SlopeInterceptLineNode(line, graph, modelViewTransform);
    }
}

