/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.linegraphing.slopeintercept.view;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.colorado.phet.common.phetcommon.util.RichSimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.colorado.phet.common.piccolophet.nodes.PhetPText;
import edu.colorado.phet.common.piccolophet.nodes.kit.ZeroOffsetNode;
import edu.colorado.phet.linegraphing.common.LGColors;
import edu.colorado.phet.linegraphing.common.LGResources;
import edu.colorado.phet.linegraphing.common.LGSimSharing;
import edu.colorado.phet.linegraphing.common.model.Fraction;
import edu.colorado.phet.linegraphing.common.model.Line;
import edu.colorado.phet.linegraphing.common.view.DynamicValueNode;
import edu.colorado.phet.linegraphing.common.view.EquationNode;
import edu.colorado.phet.linegraphing.common.view.MinusNode;
import edu.colorado.phet.linegraphing.common.view.PlusNode;
import edu.colorado.phet.linegraphing.common.view.SlopeUndefinedNode;
import edu.colorado.phet.linegraphing.common.view.UndefinedSlopeIndicator;
import edu.colorado.phet.linegraphing.common.view.spinner.SlopeSpinnerNode;
import edu.colorado.phet.linegraphing.common.view.spinner.SpinnerNode;
import edu.colorado.phet.linegraphing.common.view.spinner.SpinnerStateIndicator;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.Color;
import java.text.MessageFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlopeInterceptEquationNode
extends EquationNode {
    private final Property<Double> rise;
    private final Property<Double> run;
    private final Property<Double> yIntercept;
    private final Property<Double> yInterceptNumerator;
    private final Property<Double> yInterceptDenominator;
    private boolean updatingControls;
    private final PNode yNode;
    private final PNode equalsNode;
    private final PNode slopeMinusSignNode;
    private final PNode riseNode;
    private final PNode runNode;
    private final PNode xNode;
    private final PNode operatorNode;
    private final PNode yInterceptNode;
    private final PNode yInterceptNumeratorNode;
    private final PNode yInterceptDenominatorNode;
    private final PNode yInterceptMinusSignNode;
    private final PPath slopeFractionLineNode;
    private final PPath yInterceptFractionLineNode;

    public SlopeInterceptEquationNode(Line line, PhetFont phetFont, Color color) {
        this(new Property<Line>(line), new Property<DoubleRange>(new DoubleRange(0.0, 1.0)), new Property<DoubleRange>(new DoubleRange(0.0, 1.0)), new Property<DoubleRange>(new DoubleRange(0.0, 1.0)), false, false, phetFont, phetFont, color);
    }

    public SlopeInterceptEquationNode(final Property<Line> property, Property<DoubleRange> property2, Property<DoubleRange> property3, Property<DoubleRange> property4, final boolean bl, final boolean bl2, PhetFont phetFont, final PhetFont phetFont2, final Color color) {
        super(phetFont2.getSize());
        this.rise = new Property<Double>(property.get().rise);
        this.run = new Property<Double>(property.get().run);
        this.yIntercept = new Property<Double>(property.get().y1);
        Fraction fraction = property.get().getYIntercept();
        this.yInterceptNumerator = new Property<Double>(Double.valueOf(fraction.numerator));
        this.yInterceptDenominator = new Property<Double>(Double.valueOf(fraction.denominator));
        double d = SlopeInterceptEquationNode.computeMaxSlopeSpinnerWidth(property2, property3, phetFont, FORMAT);
        this.yNode = new PhetPText(LGResources.Strings.SYMBOL_Y, phetFont2, color);
        this.equalsNode = new PhetPText("=", phetFont2, color);
        this.slopeMinusSignNode = new MinusNode(this.signLineSize, color);
        if (bl) {
            this.riseNode = new ZeroOffsetNode((PNode)new SlopeSpinnerNode.RiseSpinnerNode(LGSimSharing.UserComponents.riseSpinner, this.rise, this.run, property2, new SpinnerStateIndicator.SlopeColors(), phetFont, FORMAT));
            this.runNode = new ZeroOffsetNode((PNode)new SlopeSpinnerNode.RunSpinnerNode(LGSimSharing.UserComponents.runSpinner, this.rise, this.run, property3, new SpinnerStateIndicator.SlopeColors(), phetFont, FORMAT));
        } else {
            this.riseNode = new DynamicValueNode(this.rise, FORMAT, phetFont2, color, true);
            this.runNode = new DynamicValueNode(this.run, FORMAT, phetFont2, color, true);
        }
        this.slopeFractionLineNode = new PPath(this.createFractionLineShape(d)){
            {
                super(shape);
                this.setStroke(null);
                this.setPaint(color);
            }
        };
        this.xNode = new PhetPText(LGResources.Strings.SYMBOL_X, phetFont2, color);
        this.operatorNode = new PNode();
        this.yInterceptMinusSignNode = new MinusNode(this.signLineSize, color);
        this.yInterceptNode = new ZeroOffsetNode((PNode)new SpinnerNode(LGSimSharing.UserComponents.interceptSpinner, this.yIntercept, property4, new SpinnerStateIndicator.InterceptColors(), phetFont, FORMAT));
        this.yInterceptNumeratorNode = new DynamicValueNode(this.yInterceptNumerator, FORMAT, phetFont2, color, true);
        this.yInterceptDenominatorNode = new DynamicValueNode(this.yInterceptDenominator, FORMAT, phetFont2, color, true);
        this.yInterceptFractionLineNode = new PPath(this.createFractionLineShape(d)){
            {
                super(shape);
                this.setStroke(null);
                this.setPaint(color);
            }
        };
        RichSimpleObserver richSimpleObserver = new RichSimpleObserver(){

            public void update() {
                if (!SlopeInterceptEquationNode.this.updatingControls) {
                    if (bl2) {
                        property.set(Line.createSlopeIntercept((Double)SlopeInterceptEquationNode.this.rise.get(), (Double)SlopeInterceptEquationNode.this.run.get(), (Double)SlopeInterceptEquationNode.this.yIntercept.get(), ((Line)property.get()).color));
                    } else {
                        Line line = (Line)property.get();
                        property.set(new Line(line.x1, line.y1, line.x1 + (Double)SlopeInterceptEquationNode.this.run.get(), line.y1 + (Double)SlopeInterceptEquationNode.this.rise.get(), ((Line)property.get()).color));
                    }
                }
            }
        };
        richSimpleObserver.observe(this.rise, this.run, this.yIntercept);
        property.addObserver(new VoidFunction1<Line>(){

            @Override
            public void apply(Line line) {
                assert (!bl2 || line.x1 == 0.0 && MathUtil.isInteger(line.y1));
                SlopeInterceptEquationNode.this.updatingControls = true;
                SlopeInterceptEquationNode.this.rise.set(bl ? line.rise : line.getSimplifiedRise());
                SlopeInterceptEquationNode.this.run.set(bl ? line.run : line.getSimplifiedRun());
                if (bl2) {
                    SlopeInterceptEquationNode.this.yIntercept.set(line.y1);
                } else {
                    Fraction fraction = ((Line)property.get()).getYIntercept();
                    SlopeInterceptEquationNode.this.yInterceptNumerator.set(Double.valueOf(fraction.numerator));
                    SlopeInterceptEquationNode.this.yInterceptDenominator.set(Double.valueOf(fraction.denominator));
                }
                SlopeInterceptEquationNode.this.updatingControls = false;
                SlopeInterceptEquationNode.this.updateLayout(line, bl, bl2, phetFont2, color);
            }
        });
    }

    private void updateLayout(Line line, boolean bl, boolean bl2, PhetFont phetFont, Color color) {
        Object object;
        this.removeAllChildren();
        this.operatorNode.removeAllChildren();
        if (line.undefinedSlope() && !bl && !bl2) {
            this.addChild(new SlopeUndefinedNode(line, phetFont, color));
            return;
        }
        double d = line.getSlope();
        boolean bl3 = d == 0.0;
        boolean bl4 = Math.abs(d) == 1.0;
        boolean bl5 = MathUtil.isInteger(d);
        boolean bl6 = d > 0.0;
        boolean bl7 = !bl3 && !bl4 && !bl5;
        this.addChild(this.yNode);
        this.addChild(this.equalsNode);
        this.yNode.setOffset(0.0, 0.0);
        this.equalsNode.setOffset(this.yNode.getFullBoundsReference().getMaxX() + this.relationalOperatorXSpacing, this.yNode.getYOffset());
        if (bl) {
            this.addChild(this.riseNode);
            this.addChild(this.slopeFractionLineNode);
            this.addChild(this.runNode);
            this.addChild(this.xNode);
            this.slopeFractionLineNode.setOffset(this.equalsNode.getFullBoundsReference().getMaxX() + this.relationalOperatorXSpacing, this.equalsNode.getFullBoundsReference().getCenterY() + this.fractionLineYFudgeFactor);
            this.riseNode.setOffset(this.slopeFractionLineNode.getFullBoundsReference().getCenterX() - this.riseNode.getFullBoundsReference().getWidth() / 2.0, this.slopeFractionLineNode.getFullBoundsReference().getMinY() - this.riseNode.getFullBoundsReference().getHeight() - this.spinnersYSpacing);
            this.runNode.setOffset(this.slopeFractionLineNode.getFullBoundsReference().getCenterX() - this.runNode.getFullBoundsReference().getWidth() / 2.0, this.slopeFractionLineNode.getFullBoundsReference().getMinY() + this.spinnersYSpacing);
            this.xNode.setOffset(this.slopeFractionLineNode.getFullBoundsReference().getMaxX() + this.fractionalSlopeXSpacing, this.yNode.getYOffset());
        } else {
            double d2;
            if (bl6 || bl3) {
                object = this.equalsNode;
                d2 = this.relationalOperatorXSpacing;
            } else {
                this.addChild(this.slopeMinusSignNode);
                this.slopeMinusSignNode.setOffset(this.equalsNode.getFullBoundsReference().getMaxX() + this.relationalOperatorXSpacing, this.equalsNode.getFullBoundsReference().getCenterY() - this.slopeMinusSignNode.getFullBoundsReference().getHeight() / 2.0 + this.slopeSignYFudgeFactor + this.slopeSignYOffset);
                object = this.slopeMinusSignNode;
                double d3 = d2 = bl7 ? this.fractionSignXSpacing : this.integerSignXSpacing;
            }
            if (line.undefinedSlope() || bl7) {
                this.addChild(this.riseNode);
                this.addChild(this.slopeFractionLineNode);
                this.addChild(this.runNode);
                this.addChild(this.xNode);
                double d4 = Math.max(this.riseNode.getFullBoundsReference().getWidth(), this.runNode.getFullBoundsReference().getWidth());
                this.slopeFractionLineNode.setPathTo(this.createFractionLineShape(d4));
                this.slopeFractionLineNode.setOffset(((PNode)object).getFullBoundsReference().getMaxX() + d2, this.equalsNode.getFullBoundsReference().getCenterY() + this.fractionLineYFudgeFactor);
                this.riseNode.setOffset(this.slopeFractionLineNode.getFullBoundsReference().getCenterX() - this.riseNode.getFullBoundsReference().getWidth() / 2.0, this.slopeFractionLineNode.getFullBoundsReference().getMinY() - this.riseNode.getFullBoundsReference().getHeight() - this.ySpacing);
                this.runNode.setOffset(this.slopeFractionLineNode.getFullBoundsReference().getCenterX() - this.runNode.getFullBoundsReference().getWidth() / 2.0, this.slopeFractionLineNode.getFullBoundsReference().getMinY() + this.ySpacing);
                this.xNode.setOffset(this.slopeFractionLineNode.getFullBoundsReference().getMaxX() + this.fractionalSlopeXSpacing, this.yNode.getYOffset());
            } else if (!bl3) {
                if (bl4) {
                    this.addChild(this.xNode);
                    this.xNode.setOffset(((PNode)object).getFullBoundsReference().getMaxX() + d2, this.yNode.getYOffset());
                } else if (bl5) {
                    this.addChild(this.riseNode);
                    this.addChild(this.xNode);
                    this.riseNode.setOffset(((PNode)object).getFullBoundsReference().getMaxX() + d2, this.yNode.getYOffset());
                    this.xNode.setOffset(this.riseNode.getFullBoundsReference().getMaxX() + this.integerSlopeXSpacing, this.yNode.getYOffset());
                } else {
                    throw new IllegalStateException("programming error, didn't handle some slope case");
                }
            }
        }
        if (bl2) {
            if (bl3 && !bl) {
                this.addChild(this.yInterceptNode);
                this.yInterceptNode.setOffset(this.equalsNode.getFullBoundsReference().getMaxX() + this.relationalOperatorXSpacing, this.yNode.getFullBoundsReference().getCenterY() - this.yInterceptNode.getFullBoundsReference().getHeight() / 2.0);
            } else {
                this.addChild(this.operatorNode);
                this.addChild(this.yInterceptNode);
                this.operatorNode.addChild(new PlusNode(this.operatorLineSize, color));
                this.operatorNode.setOffset(this.xNode.getFullBoundsReference().getMaxX() + this.operatorXSpacing, this.equalsNode.getFullBoundsReference().getCenterY() - this.operatorNode.getFullBoundsReference().getHeight() / 2.0 + this.operatorYFudgeFactor);
                this.yInterceptNode.setOffset(this.operatorNode.getFullBoundsReference().getMaxX() + this.operatorXSpacing, this.yNode.getFullBoundsReference().getCenterY() - this.yInterceptNode.getFullBoundsReference().getHeight() / 2.0);
            }
        } else {
            boolean bl8;
            object = line.getYIntercept();
            boolean bl9 = ((Fraction)object).toDecimal() == 0.0;
            boolean bl10 = ((Fraction)object).isInteger();
            boolean bl11 = bl8 = ((Fraction)object).toDecimal() > 0.0;
            if (bl9) {
                if (bl3 && !bl) {
                    this.addChild(this.yInterceptNumeratorNode);
                    this.yInterceptNumeratorNode.setOffset(this.equalsNode.getFullBoundsReference().getMaxX() + this.relationalOperatorXSpacing, this.yNode.getFullBoundsReference().getCenterY() - this.yInterceptNumeratorNode.getFullBoundsReference().getHeight() / 2.0);
                }
            } else if (bl8 && bl3 && !bl) {
                this.addChild(this.yInterceptNumeratorNode);
                this.yInterceptNumeratorNode.setOffset(this.equalsNode.getFullBoundsReference().getMaxX() + this.relationalOperatorXSpacing, this.yNode.getFullBoundsReference().getCenterY() - this.yInterceptNumeratorNode.getFullBoundsReference().getHeight() / 2.0);
            } else if (!bl8 && bl3 && !bl) {
                this.addChild(this.yInterceptMinusSignNode);
                this.addChild(this.yInterceptNumeratorNode);
                this.yInterceptMinusSignNode.setOffset(this.equalsNode.getFullBoundsReference().getMaxX() + this.relationalOperatorXSpacing, this.equalsNode.getFullBoundsReference().getCenterY() - this.yInterceptMinusSignNode.getFullBoundsReference().getHeight() / 2.0 + this.operatorYFudgeFactor);
                this.yInterceptNumeratorNode.setOffset(this.yInterceptMinusSignNode.getFullBoundsReference().getMaxX() + this.integerSignXSpacing, this.yNode.getFullBoundsReference().getCenterY() - this.yInterceptNumeratorNode.getFullBoundsReference().getHeight() / 2.0);
            } else {
                this.addChild(this.operatorNode);
                this.operatorNode.addChild(bl8 ? new PlusNode(this.operatorLineSize, color) : new MinusNode(this.operatorLineSize, color));
                this.operatorNode.setOffset(this.xNode.getFullBoundsReference().getMaxX() + this.operatorXSpacing, this.equalsNode.getFullBoundsReference().getCenterY() - this.operatorNode.getFullBoundsReference().getHeight() / 2.0 + this.operatorYFudgeFactor);
                if (bl10) {
                    this.addChild(this.yInterceptNumeratorNode);
                    this.yInterceptNumeratorNode.setOffset(this.operatorNode.getFullBoundsReference().getMaxX() + this.operatorXSpacing, this.yNode.getFullBoundsReference().getCenterY() - this.yInterceptNumeratorNode.getFullBoundsReference().getHeight() / 2.0);
                } else {
                    this.addChild(this.yInterceptNumeratorNode);
                    this.addChild(this.yInterceptFractionLineNode);
                    this.addChild(this.yInterceptDenominatorNode);
                    double d5 = Math.max(this.yInterceptNumeratorNode.getFullBoundsReference().getWidth(), this.yInterceptDenominatorNode.getFullBoundsReference().getWidth());
                    this.yInterceptFractionLineNode.setPathTo(this.createFractionLineShape(d5));
                    this.yInterceptFractionLineNode.setOffset(this.operatorNode.getFullBoundsReference().getMaxX() + this.operatorXSpacing, this.equalsNode.getFullBoundsReference().getCenterY() + this.fractionLineYFudgeFactor);
                    this.yInterceptNumeratorNode.setOffset(this.yInterceptFractionLineNode.getFullBoundsReference().getCenterX() - this.yInterceptNumeratorNode.getFullBoundsReference().getWidth() / 2.0, this.yInterceptFractionLineNode.getFullBoundsReference().getMinY() - this.yInterceptNumeratorNode.getFullBoundsReference().getHeight() - this.ySpacing);
                    this.yInterceptDenominatorNode.setOffset(this.yInterceptFractionLineNode.getFullBoundsReference().getCenterX() - this.yInterceptDenominatorNode.getFullBoundsReference().getWidth() / 2.0, this.yInterceptFractionLineNode.getFullBoundsReference().getMaxY() + this.ySpacing);
                }
            }
        }
        if (line.undefinedSlope()) {
            object = new UndefinedSlopeIndicator(this.getFullBoundsReference().getWidth(), this.getFullBoundsReference().getHeight());
            ((PNode)object).setOffset(0.0, this.slopeFractionLineNode.getFullBoundsReference().getCenterY() - ((PNode)object).getFullBoundsReference().getHeight() / 2.0 + this.undefinedSlopeYFudgeFactor);
            this.addChild((PNode)object);
        }
    }

    public static PNode createGeneralFormNode() {
        String string = MessageFormat.format("{0} = {1}{2} + {3}", LGResources.Strings.SYMBOL_Y, LGResources.Strings.SYMBOL_SLOPE, LGResources.Strings.SYMBOL_X, LGResources.Strings.SYMBOL_INTERCEPT);
        return new HTMLNode(string, LGColors.INTERACTIVE_LINE, new PhetFont(1, 18));
    }
}

