/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.linegraphing.slope.view;

import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentTypes;
import edu.colorado.phet.common.phetcommon.util.RichSimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.linegraphing.common.LGColors;
import edu.colorado.phet.linegraphing.common.LGSimSharing;
import edu.colorado.phet.linegraphing.common.model.Graph;
import edu.colorado.phet.linegraphing.common.model.Line;
import edu.colorado.phet.linegraphing.common.view.LineFormsGraphNode;
import edu.colorado.phet.linegraphing.common.view.LineFormsViewProperties;
import edu.colorado.phet.linegraphing.common.view.LineNode;
import edu.colorado.phet.linegraphing.common.view.manipulator.LineManipulatorNode;
import edu.colorado.phet.linegraphing.common.view.manipulator.X1Y1DragHandler;
import edu.colorado.phet.linegraphing.common.view.manipulator.X2Y2DragHandler;
import edu.colorado.phet.linegraphing.slope.model.SlopeModel;
import edu.colorado.phet.linegraphing.slope.view.SlopeLineNode;
import java.awt.geom.Point2D;

public class SlopeGraphNode
extends LineFormsGraphNode {
    private final LineManipulatorNode x1y1ManipulatorNode = new LineManipulatorNode(this.getManipulatorDiameter(), LGColors.POINT_X1_Y1);
    private final LineManipulatorNode x2y2ManipulatorNode;

    public SlopeGraphNode(final SlopeModel slopeModel, final LineFormsViewProperties lineFormsViewProperties) {
        super(slopeModel, lineFormsViewProperties);
        this.x1y1ManipulatorNode.addInputEventListener(new X1Y1DragHandler(LGSimSharing.UserComponents.x1y1Manipulator, UserComponentTypes.sprite, this.x1y1ManipulatorNode, slopeModel.mvt, slopeModel.interactiveLine, slopeModel.x1Range, slopeModel.y1Range, false));
        this.x2y2ManipulatorNode = new LineManipulatorNode(this.getManipulatorDiameter(), LGColors.POINT_X2_Y2);
        this.x2y2ManipulatorNode.addInputEventListener(new X2Y2DragHandler(LGSimSharing.UserComponents.x2y2Manipulator, UserComponentTypes.sprite, this.x2y2ManipulatorNode, slopeModel.mvt, slopeModel.interactiveLine, slopeModel.x2Range, slopeModel.y2Range));
        this.addChild(this.x1y1ManipulatorNode);
        this.addChild(this.x2y2ManipulatorNode);
        slopeModel.interactiveLine.addObserver(new VoidFunction1<Line>(){

            @Override
            public void apply(Line line) {
                SlopeGraphNode.this.x1y1ManipulatorNode.setOffset(slopeModel.mvt.modelToView(new Point2D.Double(line.x1, line.y1)));
                SlopeGraphNode.this.x2y2ManipulatorNode.setOffset(slopeModel.mvt.modelToView(new Point2D.Double(line.x2, line.y2)));
            }
        });
        RichSimpleObserver richSimpleObserver = new RichSimpleObserver(){

            public void update() {
                boolean bl = lineFormsViewProperties.linesVisible.get() != false && lineFormsViewProperties.interactiveLineVisible.get() != false;
                SlopeGraphNode.this.x1y1ManipulatorNode.setVisible(bl);
                SlopeGraphNode.this.x2y2ManipulatorNode.setVisible(bl);
            }
        };
        richSimpleObserver.observe(lineFormsViewProperties.linesVisible, lineFormsViewProperties.interactiveLineVisible);
    }

    protected LineNode createLineNode(Line line, Graph graph, ModelViewTransform modelViewTransform) {
        return new SlopeLineNode(line, graph, modelViewTransform);
    }
}

