/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.linegraphing.slope.view;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.DefaultDecimalFormat;
import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.colorado.phet.common.phetcommon.util.RichSimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.nodes.PhetPText;
import edu.colorado.phet.common.piccolophet.nodes.kit.ZeroOffsetNode;
import edu.colorado.phet.linegraphing.common.LGColors;
import edu.colorado.phet.linegraphing.common.LGResources;
import edu.colorado.phet.linegraphing.common.LGSimSharing;
import edu.colorado.phet.linegraphing.common.model.Line;
import edu.colorado.phet.linegraphing.common.view.EquationNode;
import edu.colorado.phet.linegraphing.common.view.MinusNode;
import edu.colorado.phet.linegraphing.common.view.NumberBackgroundNode;
import edu.colorado.phet.linegraphing.common.view.UndefinedSlopeIndicator;
import edu.colorado.phet.linegraphing.common.view.spinner.CoordinateSpinnerNode;
import edu.colorado.phet.linegraphing.common.view.spinner.SpinnerStateIndicator;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.text.MessageFormat;
import java.text.NumberFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlopeEquationNode
extends EquationNode {
    private final NumberFormat FORMAT = new DefaultDecimalFormat("0");
    private boolean updatingControls;
    private PNode unsimplifiedRiseNode;
    private PNode unsimplifiedRunNode;

    public SlopeEquationNode(final Property<Line> property, Property<DoubleRange> property2, Property<DoubleRange> property3, PhetFont phetFont, final PhetFont phetFont2, final Color color) {
        super(phetFont2.getSize());
        final Property<Double> property4 = new Property<Double>(property.get().x1);
        final Property<Double> property5 = new Property<Double>(property.get().y1);
        final Property<Double> property6 = new Property<Double>(property.get().x2);
        final Property<Double> property7 = new Property<Double>(property.get().y2);
        PhetPText phetPText = new PhetPText(LGResources.Strings.SYMBOL_SLOPE, phetFont2, color);
        PhetPText phetPText2 = new PhetPText("=", phetFont2, color);
        ZeroOffsetNode zeroOffsetNode = new ZeroOffsetNode((PNode)new CoordinateSpinnerNode(LGSimSharing.UserComponents.y2Spinner, property7, property6, property5, property4, property3, new SpinnerStateIndicator.X2Y2Colors(), phetFont, this.FORMAT));
        PhetPText phetPText3 = new PhetPText("-", phetFont2, color);
        ZeroOffsetNode zeroOffsetNode2 = new ZeroOffsetNode((PNode)new CoordinateSpinnerNode(LGSimSharing.UserComponents.y1Spinner, property5, property4, property7, property6, property3, new SpinnerStateIndicator.X1Y1Colors(), phetFont, this.FORMAT));
        PhetPPath phetPPath = new PhetPPath(this.createFractionLineShape(10.0), color, null, null);
        ZeroOffsetNode zeroOffsetNode3 = new ZeroOffsetNode((PNode)new CoordinateSpinnerNode(LGSimSharing.UserComponents.x2Spinner, property6, property7, property4, property5, property2, new SpinnerStateIndicator.X2Y2Colors(), phetFont, this.FORMAT));
        PhetPText phetPText4 = new PhetPText("-", phetFont2, color);
        ZeroOffsetNode zeroOffsetNode4 = new ZeroOffsetNode((PNode)new CoordinateSpinnerNode(LGSimSharing.UserComponents.x1Spinner, property4, property5, property6, property7, property2, new SpinnerStateIndicator.X1Y1Colors(), phetFont, this.FORMAT));
        PhetPText phetPText5 = new PhetPText("=", phetFont2, color);
        this.unsimplifiedRiseNode = new PNode();
        this.unsimplifiedRunNode = new PNode();
        final PhetPPath phetPPath2 = new PhetPPath(this.createFractionLineShape(10.0), color, null, null);
        double d = Math.max(property2.get().getLength(), property3.get().getLength());
        final double d2 = new PhetPText(this.FORMAT.format(-d), phetFont, color).getFullBoundsReference().getWidth();
        final PNode pNode = new PNode();
        this.addChild(pNode);
        pNode.addChild(phetPText);
        pNode.addChild(phetPText2);
        pNode.addChild(zeroOffsetNode);
        pNode.addChild(phetPText3);
        pNode.addChild(zeroOffsetNode2);
        pNode.addChild(phetPPath);
        pNode.addChild(zeroOffsetNode3);
        pNode.addChild(phetPText4);
        pNode.addChild(zeroOffsetNode4);
        pNode.addChild(phetPText5);
        pNode.addChild(this.unsimplifiedRiseNode);
        pNode.addChild(phetPPath2);
        pNode.addChild(this.unsimplifiedRunNode);
        phetPText.setOffset(0.0, 0.0);
        phetPText2.setOffset(phetPText.getFullBoundsReference().getMaxX() + this.relationalOperatorXSpacing, phetPText.getYOffset());
        phetPPath.setOffset(phetPText2.getFullBoundsReference().getMaxX() + this.relationalOperatorXSpacing, phetPText2.getFullBoundsReference().getCenterY() + this.fractionLineYFudgeFactor);
        zeroOffsetNode.setOffset(phetPPath.getXOffset(), phetPPath.getFullBoundsReference().getMinY() - zeroOffsetNode.getFullBoundsReference().getHeight() - this.spinnersYSpacing);
        phetPText3.setOffset(zeroOffsetNode.getFullBoundsReference().getMaxX() + this.operatorXSpacing, zeroOffsetNode.getFullBoundsReference().getCenterY() - phetPText3.getFullBoundsReference().getHeight() / 2.0);
        zeroOffsetNode2.setOffset(phetPText3.getFullBoundsReference().getMaxX() + this.operatorXSpacing, zeroOffsetNode.getYOffset());
        double d3 = zeroOffsetNode2.getFullBoundsReference().getMaxX() - zeroOffsetNode.getFullBoundsReference().getMinX();
        phetPPath.setPathTo(this.createFractionLineShape(d3));
        zeroOffsetNode3.setOffset(zeroOffsetNode.getXOffset(), phetPPath.getFullBoundsReference().getMaxY() + this.spinnersYSpacing);
        phetPText4.setOffset(zeroOffsetNode3.getFullBoundsReference().getMaxX() + this.operatorXSpacing, zeroOffsetNode3.getFullBoundsReference().getCenterY() - phetPText4.getFullBoundsReference().getHeight() / 2.0);
        zeroOffsetNode4.setOffset(phetPText4.getFullBoundsReference().getMaxX() + this.operatorXSpacing, zeroOffsetNode3.getYOffset());
        phetPText5.setOffset(phetPPath.getFullBoundsReference().getMaxX() + this.relationalOperatorXSpacing, phetPText2.getYOffset());
        phetPPath2.setOffset(phetPText5.getFullBoundsReference().getMaxX() + this.relationalOperatorXSpacing, phetPPath.getYOffset());
        final VoidFunction1<Line> voidFunction1 = new VoidFunction1<Line>(){

            @Override
            public void apply(Line line) {
                SlopeEquationNode.this.unsimplifiedRiseNode.setOffset(phetPPath2.getFullBoundsReference().getCenterX() - SlopeEquationNode.this.unsimplifiedRiseNode.getFullBoundsReference().getWidth() / 2.0, phetPPath2.getFullBoundsReference().getMinY() - SlopeEquationNode.this.unsimplifiedRiseNode.getFullBoundsReference().getHeight() - SlopeEquationNode.this.slopeYSpacing);
                SlopeEquationNode.this.unsimplifiedRunNode.setOffset(phetPPath2.getFullBoundsReference().getCenterX() - SlopeEquationNode.this.unsimplifiedRunNode.getFullBoundsReference().getWidth() / 2.0, phetPPath2.getFullBoundsReference().getMaxY() + SlopeEquationNode.this.slopeYSpacing);
            }
        };
        RichSimpleObserver richSimpleObserver = new RichSimpleObserver(){

            public void update() {
                if (!SlopeEquationNode.this.updatingControls) {
                    property.set(new Line((Double)property4.get(), (Double)property5.get(), (Double)property6.get(), (Double)property7.get(), ((Line)property.get()).color));
                }
            }
        };
        richSimpleObserver.observe(property4, property5, property6, property7);
        property.addObserver(new VoidFunction1<Line>(){
            PNode undefinedSlopeIndicator;

            @Override
            public void apply(Line line) {
                SlopeEquationNode.this.updatingControls = true;
                property4.set(line.x1);
                property5.set(line.y1);
                property6.set(line.x2);
                property7.set(line.y2);
                SlopeEquationNode.this.updatingControls = false;
                SlopeEquationNode.this.removeChild(SlopeEquationNode.this.unsimplifiedRiseNode);
                SlopeEquationNode.this.unsimplifiedRiseNode = new NumberBackgroundNode(line.rise, SlopeEquationNode.this.FORMAT, phetFont2, color, LGColors.SLOPE, 3.0, 3.0, 10.0, d2);
                SlopeEquationNode.this.addChild(SlopeEquationNode.this.unsimplifiedRiseNode);
                SlopeEquationNode.this.removeChild(SlopeEquationNode.this.unsimplifiedRunNode);
                SlopeEquationNode.this.unsimplifiedRunNode = new NumberBackgroundNode(line.run, SlopeEquationNode.this.FORMAT, phetFont2, color, LGColors.SLOPE, 3.0, 3.0, 10.0, d2);
                SlopeEquationNode.this.addChild(SlopeEquationNode.this.unsimplifiedRunNode);
                phetPPath2.setPathTo(SlopeEquationNode.this.createFractionLineShape(Math.max(SlopeEquationNode.this.unsimplifiedRiseNode.getFullBoundsReference().getWidth(), SlopeEquationNode.this.unsimplifiedRunNode.getFullBoundsReference().getWidth())));
                voidFunction1.apply(line);
                if (this.undefinedSlopeIndicator != null) {
                    SlopeEquationNode.this.removeChild(this.undefinedSlopeIndicator);
                }
                if (line.undefinedSlope()) {
                    this.undefinedSlopeIndicator = new UndefinedSlopeIndicator(SlopeEquationNode.this.getFullBoundsReference().getWidth(), SlopeEquationNode.this.getFullBoundsReference().getHeight());
                    this.undefinedSlopeIndicator.setOffset(pNode.getXOffset(), pNode.getFullBoundsReference().getCenterY() - this.undefinedSlopeIndicator.getFullBoundsReference().getHeight() / 2.0 + SlopeEquationNode.this.undefinedSlopeYFudgeFactor);
                    SlopeEquationNode.this.addChild(this.undefinedSlopeIndicator);
                }
            }
        });
    }

    public SlopeEquationNode(Property<Line> property, PhetFont phetFont, Color color) {
        super(phetFont.getSize());
        final PhetPText phetPText = new PhetPText(MessageFormat.format(LGResources.Strings.SLOPE_IS, LGResources.Strings.SYMBOL_SLOPE), phetFont, color);
        final MinusNode minusNode = new MinusNode(this.signLineSize, color);
        final PhetPText phetPText2 = new PhetPText("?", phetFont, color);
        final PhetPText phetPText3 = new PhetPText("?", phetFont, color);
        final PhetPPath phetPPath = new PhetPPath(this.createFractionLineShape(1.0), color, null, null);
        this.addChild(phetPText);
        phetPText.setOffset(0.0, 0.0);
        VoidFunction1<Line> voidFunction1 = new VoidFunction1<Line>(){

            @Override
            public void apply(Line line) {
                SlopeEquationNode.this.removeChild(minusNode);
                SlopeEquationNode.this.removeChild(phetPText2);
                SlopeEquationNode.this.removeChild(phetPText3);
                SlopeEquationNode.this.removeChild(phetPPath);
                if (line.undefinedSlope()) {
                    SlopeEquationNode.this.addChild(phetPText2);
                    phetPText2.setText(LGResources.Strings.UNDEFINED);
                    phetPText2.setOffset(phetPText.getFullBoundsReference().getMaxX() + SlopeEquationNode.this.relationalOperatorXSpacing, phetPText.getY());
                } else if (line.getSlope() == 0.0) {
                    SlopeEquationNode.this.addChild(phetPText2);
                    phetPText2.setText("0");
                    phetPText2.setOffset(phetPText.getFullBoundsReference().getMaxX() + SlopeEquationNode.this.relationalOperatorXSpacing, phetPText.getY());
                } else {
                    double d;
                    if (line.getSlope() < 0.0) {
                        SlopeEquationNode.this.addChild(minusNode);
                        minusNode.setOffset(phetPText.getFullBoundsReference().getMaxX() + SlopeEquationNode.this.relationalOperatorXSpacing, phetPText.getFullBoundsReference().getCenterY() - minusNode.getFullBoundsReference().getHeight() / 2.0 + SlopeEquationNode.this.slopeSignYFudgeFactor + SlopeEquationNode.this.slopeSignYOffset);
                        d = minusNode.getFullBoundsReference().getMaxX() + SlopeEquationNode.this.operatorXSpacing;
                    } else {
                        d = phetPText.getFullBoundsReference().getMaxX() + SlopeEquationNode.this.relationalOperatorXSpacing;
                    }
                    if (MathUtil.isInteger(line.getSlope())) {
                        SlopeEquationNode.this.addChild(phetPText2);
                        phetPText2.setText(SlopeEquationNode.this.FORMAT.format(Math.abs(line.getSlope())));
                        phetPText2.setOffset(d, phetPText.getYOffset());
                    } else {
                        SlopeEquationNode.this.addChild(phetPPath);
                        SlopeEquationNode.this.addChild(phetPText2);
                        SlopeEquationNode.this.addChild(phetPText3);
                        phetPText2.setText(SlopeEquationNode.this.FORMAT.format(Math.abs(line.getSimplifiedRise())));
                        phetPText3.setText(SlopeEquationNode.this.FORMAT.format(Math.abs(line.getSimplifiedRun())));
                        phetPPath.setPathTo(SlopeEquationNode.this.createFractionLineShape(Math.max(phetPText2.getFullBoundsReference().getWidth(), phetPText3.getFullBoundsReference().getWidth())));
                        phetPPath.setOffset(d, phetPText.getFullBoundsReference().getCenterY() + SlopeEquationNode.this.fractionLineYFudgeFactor);
                        phetPText2.setOffset(phetPPath.getFullBoundsReference().getCenterX() - phetPText2.getFullBoundsReference().getWidth() / 2.0, phetPPath.getFullBoundsReference().getMinY() - phetPText2.getFullBoundsReference().getHeight() - SlopeEquationNode.this.ySpacing);
                        phetPText3.setOffset(phetPPath.getFullBoundsReference().getCenterX() - phetPText3.getFullBoundsReference().getWidth() / 2.0, phetPPath.getFullBoundsReference().getMaxY() + SlopeEquationNode.this.ySpacing);
                    }
                }
            }
        };
        property.addObserver(voidFunction1);
    }

    public SlopeEquationNode(Line line, PhetFont phetFont, Color color) {
        this(new Property<Line>(line), phetFont, color);
    }

    public static PNode createGeneralFormNode() {
        Color color = LGColors.INTERACTIVE_LINE;
        PhetFont phetFont = new PhetFont(1, 18);
        String string = MessageFormat.format("{0}&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;{1} =", LGResources.Strings.SLOPE, LGResources.Strings.SYMBOL_SLOPE);
        HTMLNode hTMLNode = new HTMLNode(string, color, phetFont);
        String string2 = "<html>{0}<font size='-1'><sub>2</sub></font> - {1}<font size='-1'><sub>1</sub></font></html>";
        String string3 = MessageFormat.format(string2, LGResources.Strings.SYMBOL_Y, LGResources.Strings.SYMBOL_Y);
        HTMLNode hTMLNode2 = new HTMLNode(string3, color, phetFont);
        String string4 = MessageFormat.format(string2, LGResources.Strings.SYMBOL_X, LGResources.Strings.SYMBOL_X);
        HTMLNode hTMLNode3 = new HTMLNode(string4, color, phetFont);
        double d = Math.max(hTMLNode2.getFullBoundsReference().getWidth(), hTMLNode3.getFullBoundsReference().getWidth());
        PPath pPath = new PPath(new Rectangle2D.Double(0.0, 0.0, d, 1.0));
        pPath.setPaint(color);
        pPath.setStroke(null);
        PNode pNode = new PNode();
        pNode.addChild(hTMLNode);
        pNode.addChild(hTMLNode2);
        pNode.addChild(hTMLNode3);
        pNode.addChild(pPath);
        hTMLNode.setOffset(0.0, 0.0);
        pPath.setOffset(hTMLNode.getFullBoundsReference().getMaxX() + 5.0, hTMLNode.getFullBoundsReference().getCenterY() - pPath.getFullBoundsReference().getHeight() / 2.0 + 3.0);
        hTMLNode2.setOffset(pPath.getFullBoundsReference().getCenterX() - hTMLNode2.getFullBoundsReference().getWidth() / 2.0, pPath.getFullBoundsReference().getMinY() - hTMLNode2.getFullBoundsReference().getHeight() - 1.0);
        hTMLNode3.setOffset(pPath.getFullBoundsReference().getCenterX() - hTMLNode3.getFullBoundsReference().getWidth() / 2.0, pPath.getFullBoundsReference().getMaxY() + 1.0);
        return new ZeroOffsetNode(pNode);
    }
}

