/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.linegraphing.linegame.view;

import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.util.IntegerRange;
import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.LinearValueControl;
import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.nodes.FaceNode;
import edu.colorado.phet.common.piccolophet.nodes.PadBoundsNode;
import edu.colorado.phet.linegraphing.common.LGColors;
import edu.colorado.phet.linegraphing.common.model.Line;
import edu.colorado.phet.linegraphing.common.model.PointTool;
import edu.colorado.phet.linegraphing.common.view.EquationNode;
import edu.colorado.phet.linegraphing.common.view.GraphNode;
import edu.colorado.phet.linegraphing.common.view.PointToolNode;
import edu.colorado.phet.linegraphing.pointslope.view.PointSlopeEquationNode;
import edu.colorado.phet.linegraphing.slopeintercept.view.SlopeInterceptEquationNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RewardNode
extends PhetPNode {
    private final ConstantDtClock clock;
    private final ArrayList<Image> graphImages;
    private final ArrayList<Image> equationImages;
    private final ArrayList<Image> pointToolImages;
    private final ArrayList<Image> smileyFaceImages;
    private final ArrayList<Image> phetLogoImages;
    private final ArrayList<Image> imagePool;
    private int population;
    private int motionDelta;
    private IMotionStrategy motionStrategy;

    public RewardNode() {
        this(new PBounds(0.0, 0.0, 1024.0, 768.0), 150, 10, 40);
    }

    private RewardNode(PBounds pBounds, int n, int n2, int n3) {
        this.setPickable(false);
        this.setChildrenPickable(false);
        this.population = n;
        this.motionDelta = n2;
        this.motionStrategy = new FallingMotionStrategy();
        this.clock = new ConstantDtClock(n3, 1.0);
        this.clock.pause();
        this.graphImages = new ArrayList();
        this.equationImages = new ArrayList();
        this.pointToolImages = new ArrayList();
        this.smileyFaceImages = new ArrayList();
        this.phetLogoImages = new ArrayList();
        Color[] colorArray = new Color[]{Color.YELLOW, Color.RED, Color.ORANGE, Color.MAGENTA, Color.CYAN, Color.GREEN};
        for (Color color : colorArray) {
            this.graphImages.add(BufferedImageUtils.toImage(GraphNode.createYEqualsXIcon(50.0, color)));
            this.graphImages.add(BufferedImageUtils.toImage(GraphNode.createYEqualsNegativeXIcon(50.0, color)));
            this.pointToolImages.add(this.createPointToolImage(color));
            this.smileyFaceImages.add(this.createSmileyFaceImage(color));
            for (int i = 0; i < 5; ++i) {
                this.equationImages.add(this.createEquationImage(color));
            }
        }
        PImage pImage = new PImage(PhetCommonResources.getImage("logos/phet-logo-120x50.jpg"));
        pImage.scale(1.0);
        this.phetLogoImages.add(pImage.toImage());
        this.imagePool = new ArrayList();
        this.clock.addClockListener(new ClockAdapter(){

            public void clockTicked(ClockEvent clockEvent) {
                RewardNode.this.step();
            }
        });
        this.setBounds(pBounds);
        this.setGraphsVisible(true);
        this.setEquationsVisible(true);
        this.setPointToolsVisible(true);
        this.setPhETLogosVisible(true);
        this.setSmileyFacesVisible(true);
    }

    private Image createEquationImage(Color color) {
        boolean bl = Math.random() < 0.5;
        PhetFont phetFont = new PhetFont(1, 24);
        EquationNode equationNode = bl ? new SlopeInterceptEquationNode(Line.createSlopeIntercept(RewardNode.getRandomNonZeroInteger(-20, 20), RewardNode.getRandomNonZeroInteger(-20, 20), RewardNode.getRandomNonZeroInteger(-20, 20)), phetFont, color) : new PointSlopeEquationNode(Line.createPointSlope(RewardNode.getRandomNonZeroInteger(-20, 20), RewardNode.getRandomNonZeroInteger(-20, 20), RewardNode.getRandomNonZeroInteger(-20, 20), RewardNode.getRandomNonZeroInteger(-20, 20)), phetFont, color);
        return new PadBoundsNode(equationNode).toImage();
    }

    private static int getRandomNonZeroInteger(int n, int n2) {
        int n3 = (int)((double)n + Math.random() * (double)(n2 - n));
        if (n3 == 0) {
            n3 = 1;
        }
        return n3;
    }

    private Image createPointToolImage(Color color) {
        Vector2D vector2D = new Vector2D(Math.random() * 20.0, Math.random() * 20.0);
        PointToolNode pointToolNode = new PointToolNode(vector2D, PointTool.Orientation.DOWN, color);
        pointToolNode.scale(0.75);
        return new PadBoundsNode(pointToolNode).toImage();
    }

    private Image createSmileyFaceImage(Color color) {
        return new PadBoundsNode(new FaceNode(40.0, color)).toImage();
    }

    public void setLevel(int n) {
        assert (n >= 1 && n <= 6);
        this.setImagesVisible(this.equationImages, n == 1 || n == 6);
        this.setImagesVisible(this.graphImages, n == 2 || n == 6);
        this.setImagesVisible(this.pointToolImages, n == 3 || n == 6);
        this.setImagesVisible(this.smileyFaceImages, n == 4 || n == 6);
        this.setImagesVisible(this.phetLogoImages, n == 5 || n == 6);
    }

    @Override
    public boolean setBounds(Rectangle2D rectangle2D) {
        if (rectangle2D.isEmpty()) {
            throw new IllegalArgumentException("bounds are empty");
        }
        boolean bl = false;
        if (!rectangle2D.equals(this.getBounds())) {
            bl = super.setBounds(rectangle2D);
            this.updateImages(true);
        }
        return bl;
    }

    private void setClockDelay(int n) {
        this.clock.setDelay(n);
    }

    private int getClockDelay() {
        return this.clock.getDelay();
    }

    private void setPopulation(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("population must be > 0: " + n);
        }
        if (n != this.getPopulation()) {
            this.population = n;
            this.updateImages(false);
        }
    }

    private int getPopulation() {
        return this.population;
    }

    private void setMotionDelta(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("motionDelta must be > 0: " + n);
        }
        if (n != this.getMotionDelta()) {
            this.motionDelta = n;
            for (int i = 0; i < this.getChildrenCount(); ++i) {
                if (!(this.getChild(i) instanceof MovingImageNode)) continue;
                int n2 = (int)Math.max(1.0, Math.random() * (double)n);
                ((MovingImageNode)this.getChild(i)).setMotionDelta(n2);
            }
        }
    }

    private int getMotionDelta() {
        return this.motionDelta;
    }

    private boolean isGraphsVisible() {
        return this.isImagesVisible(this.graphImages);
    }

    private void setGraphsVisible(boolean bl) {
        this.setImagesVisible(this.graphImages, bl);
    }

    private boolean isEquationsVisible() {
        return this.isImagesVisible(this.equationImages);
    }

    private void setEquationsVisible(boolean bl) {
        this.setImagesVisible(this.equationImages, bl);
    }

    private boolean isPointToolsVisible() {
        return this.isImagesVisible(this.pointToolImages);
    }

    private void setPointToolsVisible(boolean bl) {
        this.setImagesVisible(this.pointToolImages, bl);
    }

    private boolean isPhETLogosVisible() {
        return this.isImagesVisible(this.phetLogoImages);
    }

    private void setPhETLogosVisible(boolean bl) {
        this.setImagesVisible(this.phetLogoImages, bl);
    }

    private boolean isSmileyFacesVisible() {
        return this.isImagesVisible(this.smileyFaceImages);
    }

    private void setSmileyFacesVisible(boolean bl) {
        this.setImagesVisible(this.smileyFaceImages, bl);
    }

    private void setImagesVisible(ArrayList<Image> arrayList, boolean bl) {
        if (bl) {
            this.imagePool.addAll(arrayList);
        } else {
            this.imagePool.removeAll(arrayList);
        }
        this.updateImages(true);
    }

    private boolean isImagesVisible(ArrayList<Image> arrayList) {
        return this.imagePool.contains(arrayList.get(0));
    }

    private void setMotionStrategy(IMotionStrategy iMotionStrategy) {
        this.motionStrategy = iMotionStrategy;
    }

    private void updateImages(boolean bl) {
        block5: {
            if (bl) {
                this.removeAllChildren();
            }
            if (this.imagePool.size() <= 0) break block5;
            if (this.getChildrenCount() > this.population) {
                while (this.getChildrenCount() > this.population) {
                    this.removeChild(this.getChildrenCount() - 1);
                }
            } else {
                while (this.getChildrenCount() < this.population) {
                    this.addRandomNode();
                }
            }
        }
    }

    private void addRandomNode() {
        int n = (int)Math.max(1.0, Math.random() * (double)this.motionDelta);
        int n2 = (int)(Math.random() * (double)this.imagePool.size());
        MovingImageNode movingImageNode = new MovingImageNode(this.imagePool.get(n2), n);
        this.addChild(movingImageNode);
        PBounds pBounds = this.getBoundsReference();
        Point2D point2D = this.getRandomPoint(pBounds);
        double d = point2D.getX() - movingImageNode.getFullBoundsReference().getWidth() / 2.0;
        double d2 = point2D.getY() - movingImageNode.getFullBoundsReference().getHeight() / 2.0;
        movingImageNode.setOffset(d, d2);
    }

    private Point2D getRandomPoint(PBounds pBounds) {
        double d = pBounds.getX() + Math.random() * pBounds.getWidth();
        double d2 = pBounds.getY() + Math.random() * pBounds.getHeight();
        return new Point2D.Double(d, d2);
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.setRunning(bl);
    }

    public void setRunning(boolean bl) {
        if (bl) {
            this.clock.start();
        } else {
            this.clock.pause();
        }
    }

    public boolean isRunning() {
        return this.clock.isRunning();
    }

    private void step() {
        PBounds pBounds = this.getBoundsReference();
        for (int i = 0; i < this.getChildrenCount(); ++i) {
            if (!(this.getChild(i) instanceof MovingImageNode)) continue;
            this.motionStrategy.step((MovingImageNode)this.getChild(i), pBounds);
        }
    }

    public static void main(String[] stringArray) {
        IntegerRange integerRange = new IntegerRange(50, 1000, 500);
        IntegerRange integerRange2 = new IntegerRange(1, 20, 5);
        IntegerRange integerRange3 = new IntegerRange(10, 200, 60);
        PBounds pBounds = new PBounds(0.0, 0.0, 100.0, 100.0);
        final RewardNode rewardNode = new RewardNode(pBounds, integerRange.getDefault(), integerRange2.getDefault(), integerRange3.getDefault());
        rewardNode.setRunning(true);
        PhetPCanvas phetPCanvas = new PhetPCanvas(){

            protected void updateLayout() {
                PBounds pBounds = this.getWorldBounds();
                if (pBounds.getWidth() > 0.0 && pBounds.getHeight() > 0.0) {
                    rewardNode.setBounds(pBounds);
                }
            }
        };
        PDimension pDimension = new PDimension(1008.0, 679.0);
        phetPCanvas.setWorldTransformStrategy(new PhetPCanvas.CenteredStage(phetPCanvas, pDimension));
        phetPCanvas.setBackground(LGColors.CANVAS);
        phetPCanvas.addWorldChild(rewardNode);
        final JitteryMotionStrategy jitteryMotionStrategy = new JitteryMotionStrategy();
        final FallingMotionStrategy fallingMotionStrategy = new FallingMotionStrategy();
        JRadioButton jRadioButton = new JRadioButton("jittery");
        jRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                rewardNode.setMotionStrategy(jitteryMotionStrategy);
            }
        });
        JRadioButton jRadioButton2 = new JRadioButton("falling");
        jRadioButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                rewardNode.setMotionStrategy(fallingMotionStrategy);
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        rewardNode.setMotionStrategy(fallingMotionStrategy);
        jRadioButton2.setSelected(true);
        VerticalLayoutPanel verticalLayoutPanel = new VerticalLayoutPanel();
        verticalLayoutPanel.setBorder(new TitledBorder("Motion Strategy"));
        ((Container)verticalLayoutPanel).add(jRadioButton);
        ((Container)verticalLayoutPanel).add(jRadioButton2);
        final JCheckBox jCheckBox = new JCheckBox("graphs");
        jCheckBox.setSelected(rewardNode.isGraphsVisible());
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                rewardNode.setGraphsVisible(jCheckBox.isSelected());
            }
        });
        final JCheckBox jCheckBox2 = new JCheckBox("equations");
        jCheckBox2.setSelected(rewardNode.isEquationsVisible());
        jCheckBox2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                rewardNode.setEquationsVisible(jCheckBox2.isSelected());
            }
        });
        final JCheckBox jCheckBox3 = new JCheckBox("point tools");
        jCheckBox3.setSelected(rewardNode.isPointToolsVisible());
        jCheckBox3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                rewardNode.setPointToolsVisible(jCheckBox3.isSelected());
            }
        });
        final JCheckBox jCheckBox4 = new JCheckBox("PhET logos");
        jCheckBox4.setSelected(rewardNode.isPhETLogosVisible());
        jCheckBox4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                rewardNode.setPhETLogosVisible(jCheckBox4.isSelected());
            }
        });
        final JCheckBox jCheckBox5 = new JCheckBox("smiley faces");
        jCheckBox5.setSelected(rewardNode.isSmileyFacesVisible());
        jCheckBox5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                rewardNode.setSmileyFacesVisible(jCheckBox5.isSelected());
            }
        });
        VerticalLayoutPanel verticalLayoutPanel2 = new VerticalLayoutPanel();
        verticalLayoutPanel2.setBorder(new TitledBorder("Objects"));
        ((Container)verticalLayoutPanel2).add(jCheckBox);
        ((Container)verticalLayoutPanel2).add(jCheckBox2);
        ((Container)verticalLayoutPanel2).add(jCheckBox3);
        ((Container)verticalLayoutPanel2).add(jCheckBox4);
        ((Container)verticalLayoutPanel2).add(jCheckBox5);
        final LinearValueControl linearValueControl = new LinearValueControl(integerRange.getMin(), integerRange.getMax(), "population:", "##0", "");
        linearValueControl.setBorder(BorderFactory.createEtchedBorder());
        linearValueControl.setValue(integerRange.getDefault());
        linearValueControl.setToolTipText("how many images are in the play area");
        linearValueControl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                rewardNode.setPopulation((int)linearValueControl.getValue());
            }
        });
        final LinearValueControl linearValueControl2 = new LinearValueControl(integerRange2.getMin(), integerRange2.getMax(), "motion delta:", "##0", "pixels");
        linearValueControl2.setBorder(BorderFactory.createEtchedBorder());
        linearValueControl2.setValue(integerRange2.getDefault());
        linearValueControl2.setToolTipText("how far images move each time the clock ticks");
        linearValueControl2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                rewardNode.setMotionDelta((int)linearValueControl2.getValue());
            }
        });
        final LinearValueControl linearValueControl3 = new LinearValueControl(integerRange3.getMin(), integerRange3.getMax(), "clock delay:", "##0", "ms");
        linearValueControl3.setBorder(BorderFactory.createEtchedBorder());
        linearValueControl3.setToolTipText("how frequently the simulation clock ticks");
        linearValueControl3.setValue(rewardNode.getClockDelay());
        linearValueControl3.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                rewardNode.setClockDelay((int)linearValueControl3.getValue());
            }
        });
        VerticalLayoutPanel verticalLayoutPanel3 = new VerticalLayoutPanel();
        ((Container)verticalLayoutPanel3).add(verticalLayoutPanel);
        ((Container)verticalLayoutPanel3).add(verticalLayoutPanel2);
        ((Container)verticalLayoutPanel3).add(linearValueControl);
        ((Container)verticalLayoutPanel3).add(linearValueControl2);
        ((Container)verticalLayoutPanel3).add(linearValueControl3);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel.add(verticalLayoutPanel3);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)phetPCanvas, "Center");
        jPanel2.add((Component)jPanel, "East");
        JFrame jFrame = new JFrame("Game Reward test");
        jFrame.setContentPane(jPanel2);
        jFrame.setDefaultCloseOperation(3);
        PhetApplicationConfig.DEFAULT_FRAME_SETUP.initialize(jFrame);
        jFrame.setVisible(true);
    }

    public static class FallingMotionStrategy
    implements IMotionStrategy {
        public void step(MovingImageNode movingImageNode, PBounds pBounds) {
            double d = movingImageNode.getYOffset() + (double)movingImageNode.getMotionDelta();
            if (d > pBounds.getMaxY()) {
                d = pBounds.getMinY() - movingImageNode.getFullBoundsReference().getHeight();
            }
            movingImageNode.setOffset(movingImageNode.getXOffset(), d);
        }
    }

    public static interface IMotionStrategy {
        public void step(MovingImageNode var1, PBounds var2);
    }

    public static class JitteryMotionStrategy
    implements IMotionStrategy {
        public void step(MovingImageNode movingImageNode, PBounds pBounds) {
            double d = movingImageNode.getXOffset() + (double)(this.getRandomDirection() * movingImageNode.getMotionDelta());
            double d2 = movingImageNode.getYOffset() + (double)(this.getRandomDirection() * movingImageNode.getMotionDelta());
            d = Math.max(pBounds.getMinX(), Math.min(d, pBounds.getMaxX()));
            d2 = Math.max(pBounds.getMinY(), Math.min(d2, pBounds.getMaxY()));
            movingImageNode.setOffset(d, d2);
        }

        private int getRandomDirection() {
            return Math.random() > 0.5 ? 1 : -1;
        }
    }

    private static class MovingImageNode
    extends PImage {
        private int motionDelta;

        public MovingImageNode(Image image, int n) {
            super(image);
            this.motionDelta = n;
        }

        public int getMotionDelta() {
            return this.motionDelta;
        }

        public void setMotionDelta(int n) {
            this.motionDelta = n;
        }
    }
}

