/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.linegraphing.linegame.model;

import edu.colorado.phet.common.games.GameAudioPlayer;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.IntegerRange;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.linegraphing.common.LGResources;
import edu.colorado.phet.linegraphing.common.model.Graph;
import edu.colorado.phet.linegraphing.common.model.Line;
import edu.colorado.phet.linegraphing.common.model.PointTool;
import edu.colorado.phet.linegraphing.linegame.LineGameConstants;
import edu.colorado.phet.linegraphing.linegame.model.EquationForm;
import edu.colorado.phet.linegraphing.linegame.model.LineGameModel;
import edu.colorado.phet.linegraphing.linegame.model.ManipulationMode;
import edu.colorado.phet.linegraphing.linegame.view.ChallengeNode;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.geom.Point2D;

public abstract class Challenge
implements Resettable {
    public final Line answer;
    public final Property<Line> guess;
    public final String title;
    public final String description;
    public final ModelViewTransform mvt;
    public final Graph graph;
    public final EquationForm equationForm;
    public final ManipulationMode manipulationMode;
    public final PointTool pointTool1;
    public final PointTool pointTool2;
    protected boolean answerVisible;

    protected Challenge(String string, String string2, Line line, EquationForm equationForm, ManipulationMode manipulationMode, IntegerRange integerRange, IntegerRange integerRange2, Point2D point2D, Vector2D vector2D, Vector2D vector2D2) {
        assert (!line.undefinedSlope());
        this.title = string;
        this.description = string2;
        this.answer = line.withColor(LineGameConstants.ANSWER_COLOR);
        this.guess = new Property<Line>(Challenge.createInitialGuess(line, manipulationMode));
        this.equationForm = equationForm;
        this.manipulationMode = manipulationMode;
        double d = 400 / integerRange.getLength();
        this.mvt = ModelViewTransform.createOffsetScaleMapping(point2D, d, -d);
        this.graph = new Graph(integerRange, integerRange2);
        this.pointTool1 = new PointTool(vector2D, PointTool.Orientation.UP, this.graph.lines);
        this.pointTool2 = new PointTool(vector2D2, PointTool.Orientation.DOWN, this.graph.lines);
        this.guess.addObserver(new SimpleObserver(){

            public void update() {
                Challenge.this.updateGraphLines();
            }
        });
    }

    public void reset() {
        this.guess.reset();
        this.pointTool1.reset();
        this.pointTool2.reset();
        this.setAnswerVisible(false);
    }

    public abstract ChallengeNode createView(LineGameModel var1, PDimension var2, GameAudioPlayer var3);

    public boolean isCorrect() {
        return this.answer.same(this.guess.get());
    }

    public void setAnswerVisible(boolean bl) {
        this.answerVisible = bl;
        this.updateGraphLines();
    }

    protected abstract void updateGraphLines();

    private static Line createInitialGuess(Line line, ManipulationMode manipulationMode) {
        if (manipulationMode == ManipulationMode.SLOPE) {
            return Line.createPointSlope(line.x1, line.y1, 1.0, 1.0, LineGameConstants.GUESS_COLOR);
        }
        if (manipulationMode == ManipulationMode.INTERCEPT) {
            return Line.createSlopeIntercept(line.rise, line.run, 0.0, LineGameConstants.GUESS_COLOR);
        }
        if (manipulationMode == ManipulationMode.POINT) {
            return Line.createPointSlope(0.0, 0.0, line.rise, line.run, LineGameConstants.GUESS_COLOR);
        }
        if (manipulationMode == ManipulationMode.THREE_POINTS) {
            return null;
        }
        return Line.Y_EQUALS_X_LINE.withColor(LineGameConstants.GUESS_COLOR);
    }

    protected static String createTitle(String string, ManipulationMode manipulationMode) {
        if (manipulationMode == ManipulationMode.SLOPE) {
            return LGResources.Strings.SET_THE_SLOPE;
        }
        if (manipulationMode == ManipulationMode.INTERCEPT) {
            return LGResources.Strings.SET_THE_Y_INTERCEPT;
        }
        if (manipulationMode == ManipulationMode.POINT) {
            return LGResources.Strings.SET_THE_POINT;
        }
        if (manipulationMode == ManipulationMode.THREE_POINTS) {
            return LGResources.Strings.PUT_POINTS_ON_LINE;
        }
        return string;
    }
}

