/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.linegraphing.common.view.manipulator;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponentType;
import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.linegraphing.common.model.Line;
import edu.colorado.phet.linegraphing.common.view.manipulator.LineManipulatorDragHandler;
import edu.colorado.phet.linegraphing.common.view.manipulator.LineManipulatorNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.geom.Point2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YInterceptDragHandler
extends LineManipulatorDragHandler {
    private final Property<DoubleRange> y1Range;
    private double clickYOffset;

    public YInterceptDragHandler(IUserComponent iUserComponent, IUserComponentType iUserComponentType, LineManipulatorNode lineManipulatorNode, ModelViewTransform modelViewTransform, Property<Line> property, Property<DoubleRange> property2) {
        super(iUserComponent, iUserComponentType, lineManipulatorNode, modelViewTransform, property);
        this.y1Range = property2;
    }

    @Override
    protected void startDrag(PInputEvent pInputEvent) {
        super.startDrag(pInputEvent);
        Point2D point2D = pInputEvent.getPositionRelativeTo(this.manipulatorNode.getParent());
        this.clickYOffset = point2D.getY() - this.mvt.modelToViewDeltaY(((Line)this.line.get()).y1);
    }

    @Override
    protected void drag(PInputEvent pInputEvent) {
        super.drag(pInputEvent);
        Point2D point2D = pInputEvent.getPositionRelativeTo(this.manipulatorNode.getParent());
        double d = MathUtil.roundHalfUp(MathUtil.clamp(this.mvt.viewToModelDeltaY(point2D.getY() - this.clickYOffset), this.y1Range.get()));
        this.line.set(Line.createSlopeIntercept(((Line)this.line.get()).rise, ((Line)this.line.get()).run, d, ((Line)this.line.get()).color));
    }
}

