/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.linegraphing.common.view;

import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.DefaultDecimalFormat;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.PadBoundsNode;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.linegraphing.common.LGColors;
import edu.colorado.phet.linegraphing.common.model.Line;
import edu.colorado.phet.linegraphing.common.view.NumberBackgroundNode;
import edu.colorado.phet.linegraphing.slopeintercept.model.SlopeInterceptModel;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.text.NumberFormat;
import javax.swing.Icon;
import javax.swing.ImageIcon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlopeToolNode
extends PComposite {
    private static final Color LINE_COLOR = LGColors.SLOPE;
    private static final NumberFormat VALUE_FORMAT = new DefaultDecimalFormat("0");
    private static final PhetFont VALUE_FONT = new PhetFont(1, 16);
    private static final Color VALUE_TEXT_COLOR = Color.BLACK;

    public SlopeToolNode(Property<Line> property, final ModelViewTransform modelViewTransform) {
        this.setPickable(false);
        this.setChildrenPickable(false);
        property.addObserver(new VoidFunction1<Line>(){

            @Override
            public void apply(Line line) {
                SlopeToolNode.this.update(line, modelViewTransform);
            }
        });
    }

    private void update(Line line, ModelViewTransform modelViewTransform) {
        ArrowNode arrowNode;
        double d;
        double d2;
        ArrowNode arrowNode2;
        double d3;
        double d4;
        this.removeAllChildren();
        if (line.rise == 0.0 || line.run == 0.0) {
            return;
        }
        double d5 = modelViewTransform.modelToViewDeltaX(1.0);
        double d6 = modelViewTransform.modelToViewDeltaY(1.0);
        Point2D point2D = modelViewTransform.modelToView(line.x1, line.y1);
        Point2D point2D2 = modelViewTransform.modelToView(line.x2, line.y2);
        NumberBackgroundNode numberBackgroundNode = new NumberBackgroundNode(line.rise, VALUE_FORMAT, VALUE_FONT, VALUE_TEXT_COLOR, LGColors.SLOPE, 3.0, 3.0, 5.0);
        double d7 = 0.6 * d5;
        double d8 = 0.5 * d5;
        double d9 = d4 = line.rise > 0.0 ? 1.25 : -1.25;
        if (line.run > 0.0) {
            d3 = point2D.getX() - d7;
            arrowNode2 = new ArrowNode(d3, point2D.getY(), d3, point2D2.getY() + d4);
            numberBackgroundNode.setOffset(arrowNode2.getFullBoundsReference().getMinX() - numberBackgroundNode.getFullBoundsReference().getWidth() - 6.0, arrowNode2.getFullBoundsReference().getCenterY() - numberBackgroundNode.getFullBoundsReference().getHeight() / 2.0);
        } else {
            d3 = point2D.getX() + d7;
            arrowNode2 = new ArrowNode(d3, point2D.getY(), d3, point2D2.getY() + d4);
            numberBackgroundNode.setOffset(arrowNode2.getFullBoundsReference().getMaxX() + 6.0, arrowNode2.getFullBoundsReference().getCenterY() - numberBackgroundNode.getFullBoundsReference().getHeight() / 2.0);
        }
        DimensionalDelimiterNode dimensionalDelimiterNode = new DimensionalDelimiterNode(d3 - d8 / 2.0, point2D.getY(), d3 + d8 / 2.0, point2D.getY());
        DimensionalDelimiterNode dimensionalDelimiterNode2 = new DimensionalDelimiterNode(d3 - d8 / 2.0, point2D2.getY(), d3 + d8 / 2.0, point2D2.getY());
        NumberBackgroundNode numberBackgroundNode2 = new NumberBackgroundNode(line.run, VALUE_FORMAT, VALUE_FONT, VALUE_TEXT_COLOR, LGColors.SLOPE, 3.0, 3.0, 5.0);
        d4 = 0.6 * d6;
        d3 = 0.5 * d6;
        double d10 = d2 = line.run > 0.0 ? -1.0 : 1.0;
        if (line.rise > 0.0) {
            d = point2D2.getY() + d4;
            arrowNode = new ArrowNode(point2D.getX(), d, point2D2.getX() + d2, d);
            numberBackgroundNode2.setOffset(arrowNode.getFullBoundsReference().getCenterX() - numberBackgroundNode2.getFullBoundsReference().getWidth() / 2.0, arrowNode.getFullBoundsReference().getMinY() - numberBackgroundNode.getFullBoundsReference().getHeight() - 6.0);
        } else {
            d = point2D2.getY() - d4;
            arrowNode = new ArrowNode(point2D.getX(), d, point2D2.getX() + d2, d);
            numberBackgroundNode2.setOffset(arrowNode.getFullBoundsReference().getCenterX() - numberBackgroundNode2.getFullBoundsReference().getWidth() / 2.0, arrowNode.getFullBoundsReference().getMaxY() + 6.0);
        }
        DimensionalDelimiterNode dimensionalDelimiterNode3 = new DimensionalDelimiterNode(point2D.getX(), d - d3 / 2.0, point2D.getX(), d + d3 / 2.0);
        DimensionalDelimiterNode dimensionalDelimiterNode4 = new DimensionalDelimiterNode(point2D2.getX(), d - d3 / 2.0, point2D2.getX(), d + d3 / 2.0);
        this.addChild(dimensionalDelimiterNode);
        this.addChild(dimensionalDelimiterNode2);
        this.addChild(arrowNode2);
        this.addChild(dimensionalDelimiterNode3);
        this.addChild(dimensionalDelimiterNode4);
        this.addChild(arrowNode);
        this.addChild(numberBackgroundNode);
        this.addChild(numberBackgroundNode2);
    }

    public static Icon createIcon(double d) {
        PadBoundsNode padBoundsNode = new PadBoundsNode();
        SlopeInterceptModel slopeInterceptModel = new SlopeInterceptModel();
        slopeInterceptModel.interactiveLine.set(Line.createSlopeIntercept(1.0, 2.0, 0.0));
        SlopeToolNode slopeToolNode = new SlopeToolNode(slopeInterceptModel.interactiveLine, slopeInterceptModel.mvt);
        padBoundsNode.addChild(slopeToolNode);
        PPath pPath = new PPath(new Line2D.Double(slopeToolNode.getFullBoundsReference().getMinX() + 0.4 * slopeToolNode.getFullBoundsReference().getWidth(), slopeToolNode.getFullBoundsReference().getMaxY(), slopeToolNode.getFullBoundsReference().getMaxX(), slopeToolNode.getFullBoundsReference().getMinY() + 0.5 * slopeToolNode.getFullBoundsReference().getHeight()));
        pPath.setStroke(new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{6.0f, 6.0f}, 0.0f));
        padBoundsNode.addChild(pPath);
        padBoundsNode.scale(d / ((PNode)padBoundsNode).getFullBoundsReference().getWidth());
        return new ImageIcon(padBoundsNode.toImage());
    }

    private static class ArrowNode
    extends PComposite {
        private static final PDimension TIP_SIZE = new PDimension(6.0, 8.0);

        public ArrowNode(double d, double d2, double d3, double d4) {
            PhetPPath phetPPath = new PhetPPath(new Line2D.Double(d, d2, d3, d4), (Stroke)new BasicStroke(1.25f), (Paint)LINE_COLOR);
            DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath();
            if (d == d3) {
                if (d4 > d2) {
                    doubleGeneralPath.moveTo(d3 - TIP_SIZE.getWidth() / 2.0, d4 - TIP_SIZE.getHeight());
                    doubleGeneralPath.lineTo(d3, d4);
                    doubleGeneralPath.lineTo(d3 + TIP_SIZE.getWidth() / 2.0, d4 - TIP_SIZE.getHeight());
                } else {
                    doubleGeneralPath.moveTo(d3 - TIP_SIZE.getWidth() / 2.0, d4 + TIP_SIZE.getHeight());
                    doubleGeneralPath.lineTo(d3, d4);
                    doubleGeneralPath.lineTo(d3 + TIP_SIZE.getWidth() / 2.0, d4 + TIP_SIZE.getHeight());
                }
            } else if (d2 == d4) {
                if (d > d3) {
                    doubleGeneralPath.moveTo(d3 + TIP_SIZE.getHeight(), d4 - TIP_SIZE.getWidth() / 2.0);
                    doubleGeneralPath.lineTo(d3, d4);
                    doubleGeneralPath.lineTo(d3 + TIP_SIZE.getHeight(), d4 + TIP_SIZE.getWidth() / 2.0);
                } else {
                    doubleGeneralPath.moveTo(d3 - TIP_SIZE.getHeight(), d4 - TIP_SIZE.getWidth() / 2.0);
                    doubleGeneralPath.lineTo(d3, d4);
                    doubleGeneralPath.lineTo(d3 - TIP_SIZE.getHeight(), d4 + TIP_SIZE.getWidth() / 2.0);
                }
            } else {
                throw new UnsupportedOperationException("this implementation supports only horizontal and vertical arrows");
            }
            PhetPPath phetPPath2 = new PhetPPath(doubleGeneralPath.getGeneralPath(), (Stroke)new BasicStroke(1.25f), (Paint)LINE_COLOR);
            this.addChild(phetPPath2);
            this.addChild(phetPPath);
        }
    }

    private static class DimensionalDelimiterNode
    extends PPath {
        public DimensionalDelimiterNode(double d, double d2, double d3, double d4) {
            this.setStroke(new BasicStroke(1.25f));
            this.setStrokePaint(LINE_COLOR);
            this.setPathTo(new Line2D.Double(d, d2, d3, d4));
        }
    }
}

