/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.linegraphing.common.view;

import edu.colorado.phet.common.phetcommon.util.RichSimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.piccolophet.event.HighlightHandler;
import edu.colorado.phet.linegraphing.common.LGColors;
import edu.colorado.phet.linegraphing.common.model.Graph;
import edu.colorado.phet.linegraphing.common.model.Line;
import edu.colorado.phet.linegraphing.common.model.LineFormsModel;
import edu.colorado.phet.linegraphing.common.view.GraphNode;
import edu.colorado.phet.linegraphing.common.view.LineFormsViewProperties;
import edu.colorado.phet.linegraphing.common.view.LineNode;
import edu.colorado.phet.linegraphing.common.view.SlopeToolNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolox.nodes.PComposite;

public abstract class LineFormsGraphNode
extends GraphNode {
    private final LineFormsModel model;
    private final LineFormsViewProperties viewProperties;
    private final PNode savedLinesParentNode;
    private final PNode standardLinesParentNode;
    private final PNode interactiveLineParentNode;
    private final PNode slopeToolNode;
    private LineNode interactiveLineNode;

    protected LineFormsGraphNode(LineFormsModel lineFormsModel, final LineFormsViewProperties lineFormsViewProperties) {
        super(lineFormsModel.graph, lineFormsModel.mvt);
        this.model = lineFormsModel;
        this.viewProperties = lineFormsViewProperties;
        this.standardLinesParentNode = new PComposite();
        this.savedLinesParentNode = new PNode();
        this.interactiveLineParentNode = new PComposite();
        this.slopeToolNode = new SlopeToolNode(lineFormsModel.interactiveLine, lineFormsModel.mvt);
        this.addChild(this.interactiveLineParentNode);
        this.addChild(this.savedLinesParentNode);
        this.addChild(this.standardLinesParentNode);
        this.addChild(this.slopeToolNode);
        lineFormsModel.standardLines.addElementAddedObserver(new VoidFunction1<Line>(){

            @Override
            public void apply(Line line) {
                LineFormsGraphNode.this.standardLineAdded(line);
            }
        });
        lineFormsModel.standardLines.addElementRemovedObserver(new VoidFunction1<Line>(){

            @Override
            public void apply(Line line) {
                LineFormsGraphNode.this.standardLineRemoved(line);
            }
        });
        lineFormsModel.savedLines.addElementAddedObserver(new VoidFunction1<Line>(){

            @Override
            public void apply(Line line) {
                LineFormsGraphNode.this.savedLineAdded(line);
            }
        });
        lineFormsModel.savedLines.addElementRemovedObserver(new VoidFunction1<Line>(){

            @Override
            public void apply(Line line) {
                LineFormsGraphNode.this.savedLineRemoved(line);
            }
        });
        lineFormsModel.interactiveLine.addObserver(new VoidFunction1<Line>(){

            @Override
            public void apply(Line line) {
                LineFormsGraphNode.this.updateInteractiveLine(line);
            }
        });
        RichSimpleObserver richSimpleObserver = new RichSimpleObserver(){

            public void update() {
                LineFormsGraphNode.this.updateLinesVisibility(lineFormsViewProperties.linesVisible.get(), lineFormsViewProperties.interactiveLineVisible.get(), lineFormsViewProperties.slopeVisible.get());
            }
        };
        richSimpleObserver.observe(lineFormsViewProperties.linesVisible, lineFormsViewProperties.interactiveLineVisible, lineFormsViewProperties.slopeVisible);
        lineFormsViewProperties.interactiveEquationVisible.addObserver(new VoidFunction1<Boolean>(){

            @Override
            public void apply(Boolean bl) {
                if (LineFormsGraphNode.this.interactiveLineNode != null) {
                    LineFormsGraphNode.this.interactiveLineNode.setEquationVisible(bl);
                }
            }
        });
    }

    protected double getManipulatorDiameter() {
        return this.model.mvt.modelToViewDeltaX(0.85);
    }

    private void standardLineAdded(Line line) {
        this.standardLinesParentNode.addChild(this.createLineNode(line, this.model.graph, this.model.mvt));
    }

    private void standardLineRemoved(Line line) {
        LineFormsGraphNode.removeLineNode(line, this.standardLinesParentNode);
    }

    private void savedLineAdded(final Line line) {
        final LineNode lineNode = this.createLineNode(line, this.model.graph, this.model.mvt);
        this.savedLinesParentNode.addChild(lineNode);
        lineNode.addInputEventListener(new HighlightHandler.FunctionHighlightHandler(new VoidFunction1<Boolean>(){

            @Override
            public void apply(Boolean bl) {
                lineNode.updateColor(bl != false ? LGColors.SAVED_LINE_HIGHLIGHT : line.color);
            }
        }));
    }

    private void savedLineRemoved(Line line) {
        LineFormsGraphNode.removeLineNode(line, this.savedLinesParentNode);
    }

    private static void removeLineNode(Line line, PNode pNode) {
        for (int i = 0; i < pNode.getChildrenCount(); ++i) {
            PNode pNode2 = pNode.getChild(i);
            if (!(pNode2 instanceof LineNode)) continue;
            LineNode lineNode = (LineNode)pNode2;
            if (lineNode.line != line) continue;
            pNode.removeChild(pNode2);
            break;
        }
    }

    protected void updateLinesVisibility(boolean bl, boolean bl2, boolean bl3) {
        if (this.interactiveLineParentNode != null) {
            this.interactiveLineParentNode.setVisible(bl && bl2);
        }
        this.savedLinesParentNode.setVisible(bl);
        this.standardLinesParentNode.setVisible(bl);
        this.slopeToolNode.setVisible(bl3 && bl && bl2);
    }

    protected void updateInteractiveLine(Line line) {
        this.interactiveLineParentNode.removeAllChildren();
        this.interactiveLineNode = this.createLineNode(line, this.model.graph, this.model.mvt);
        this.interactiveLineNode.setEquationVisible(this.viewProperties.interactiveEquationVisible.get());
        this.interactiveLineParentNode.addChild(this.interactiveLineNode);
    }

    protected abstract LineNode createLineNode(Line var1, Graph var2, ModelViewTransform var3);
}

