/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.linegraphing.common.view;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.util.IntegerRange;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.nodes.DoubleArrowNode;
import edu.colorado.phet.common.piccolophet.nodes.PadBoundsNode;
import edu.colorado.phet.common.piccolophet.nodes.PhetPText;
import edu.colorado.phet.linegraphing.common.LGResources;
import edu.colorado.phet.linegraphing.common.model.Graph;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class GraphNode
extends PhetPNode {
    private static final Color GRID_BACKGROUND = Color.WHITE;
    private static final Stroke MINOR_GRID_LINE_STROKE = new BasicStroke(0.25f);
    private static final Color MINOR_GRID_LINE_COLOR = Color.LIGHT_GRAY;
    private static final Stroke MAJOR_GRID_LINE_STROKE = new BasicStroke(0.5f);
    private static final Color MAJOR_GRID_LINE_COLOR = Color.LIGHT_GRAY;
    private static final PDimension AXIS_ARROW_SIZE = new PDimension(10.0, 10.0);
    private static final Color AXIS_COLOR = Color.BLACK;
    private static final PhetFont AXIS_LABEL_FONT = new PhetFont(1, 16);
    private static final Stroke MINOR_TICK_STROKE = new BasicStroke(0.5f);
    private static final Color MINOR_TICK_COLOR = Color.BLACK;
    private static final Stroke MAJOR_TICK_STROKE = new BasicStroke(1.0f);
    private static final Color MAJOR_TICK_COLOR = Color.BLACK;
    private static final PhetFont MAJOR_TICK_FONT = new PhetFont(0, 16);
    private static final double MINUS_SIGN_WIDTH = new PhetPText("-", MAJOR_TICK_FONT).getFullBoundsReference().getWidth();

    protected GraphNode(Graph graph, ModelViewTransform modelViewTransform) {
        assert (graph.contains(new Vector2D(0.0, 0.0)) && graph.contains(new Vector2D(1.0, 1.0)));
        this.addChild(new GridNode(graph, modelViewTransform));
        this.addChild(new XAxisNode(graph, modelViewTransform));
        this.addChild(new YAxisNode(graph, modelViewTransform));
    }

    public static Icon createYEqualsXIcon(double d, Color color) {
        return GraphNode.createIcon(d, color, -3, -3, 3, 3);
    }

    public static Icon createYEqualsNegativeXIcon(double d, Color color) {
        return GraphNode.createIcon(d, color, -3, 3, 3, -3);
    }

    private static Icon createIcon(double d, final Color color, int n, int n2, int n3, int n4) {
        IntegerRange integerRange = new IntegerRange(-3, 3);
        Graph graph = new Graph(integerRange, integerRange);
        ModelViewTransform modelViewTransform = ModelViewTransform.createOffsetScaleMapping(new Point2D.Double(0.0, 0.0), 15.0, -15.0);
        GraphNode graphNode = new GraphNode(graph, modelViewTransform);
        Point2D point2D = modelViewTransform.modelToView(n, n2);
        Point2D point2D2 = modelViewTransform.modelToView(n3, n4);
        graphNode.addChild(new PPath((Shape)new Line2D.Double(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY())){
            {
                super(shape);
                this.setStrokePaint(color);
                this.setStroke(new BasicStroke(4.0f));
            }
        });
        graphNode.scale(d / graphNode.getFullBoundsReference().getWidth());
        return new ImageIcon(new PadBoundsNode(graphNode).toImage());
    }

    private static class GridLineNode
    extends PPath {
        public GridLineNode(double d, double d2, double d3, double d4, boolean bl) {
            this.setPathTo(new Line2D.Double(d, d2, d3, d4));
            this.setStroke(bl ? MAJOR_GRID_LINE_STROKE : MINOR_GRID_LINE_STROKE);
            this.setStrokePaint(bl ? MAJOR_GRID_LINE_COLOR : MINOR_GRID_LINE_COLOR);
        }
    }

    private static class GridNode
    extends PComposite {
        public GridNode(Graph graph, ModelViewTransform modelViewTransform) {
            PPath pPath = new PPath(new Rectangle2D.Double(modelViewTransform.modelToViewX(graph.xRange.getMin()), modelViewTransform.modelToViewY(graph.yRange.getMax()), modelViewTransform.modelToViewDeltaX(graph.getWidth()), modelViewTransform.modelToViewDeltaY(-graph.getHeight())));
            pPath.setPaint(GRID_BACKGROUND);
            pPath.setStroke(null);
            this.addChild(pPath);
            PNode pNode = new PNode();
            this.addChild(pNode);
            int n = graph.getHeight() + 1;
            double d = modelViewTransform.modelToViewX(graph.xRange.getMin());
            double d2 = modelViewTransform.modelToViewX(graph.xRange.getMax());
            for (int i = 0; i < n; ++i) {
                int n2 = graph.yRange.getMin() + i;
                if (n2 == 0) continue;
                double d3 = modelViewTransform.modelToViewY(n2);
                boolean bl = Math.abs(n2) % 5 == 0;
                pNode.addChild(new GridLineNode(d, d3, d2, d3, bl));
            }
            PNode pNode2 = new PNode();
            this.addChild(pNode2);
            int n3 = graph.getWidth() + 1;
            d2 = modelViewTransform.modelToViewY(graph.yRange.getMax());
            double d4 = modelViewTransform.modelToViewY(graph.yRange.getMin());
            for (int i = 0; i < n3; ++i) {
                double d5 = graph.xRange.getMin() + i;
                if (d5 == 0.0) continue;
                double d6 = modelViewTransform.modelToViewX(d5);
                boolean bl = Math.abs(d5) % 5.0 == 0.0;
                pNode2.addChild(new GridLineNode(d6, d2, d6, d4, bl));
            }
        }
    }

    private static class MajorTickNode
    extends PComposite {
        public MajorTickNode(double d, double d2, int n, boolean bl) {
            PPath pPath = bl ? new PPath(new Line2D.Double(d, d2 - 6.0, d, d2 + 6.0)) : new PPath(new Line2D.Double(d - 6.0, d2, d + 6.0, d2));
            pPath.setStroke(MAJOR_TICK_STROKE);
            pPath.setPaint(MAJOR_TICK_COLOR);
            this.addChild(pPath);
            PText pText = new PText(String.valueOf(n));
            pText.setFont(MAJOR_TICK_FONT);
            pText.setTextPaint(MAJOR_TICK_COLOR);
            this.addChild(pText);
            if (bl) {
                double d3 = n < 0 ? -(MINUS_SIGN_WIDTH / 2.0) : 0.0;
                pText.setOffset(pPath.getFullBoundsReference().getCenterX() - pText.getFullBoundsReference().getWidth() / 2.0 + d3, pPath.getFullBoundsReference().getMaxY() + 2.0);
            } else {
                pText.setOffset(pPath.getFullBoundsReference().getMinX() - pText.getFullBoundsReference().getWidth() - 2.0, pPath.getFullBoundsReference().getCenterY() - pText.getFullBoundsReference().getHeight() / 2.0);
            }
        }
    }

    private static class MinorTickNode
    extends PPath {
        public MinorTickNode(double d, double d2, boolean bl) {
            this.setPathTo(bl ? new Line2D.Double(d, d2 - 3.0, d, d2 + 3.0) : new Line2D.Double(d - 3.0, d2, d + 3.0, d2));
            this.setStroke(MINOR_TICK_STROKE);
            this.setPaint(MINOR_TICK_COLOR);
        }
    }

    private static class XAxisNode
    extends PComposite {
        public XAxisNode(Graph graph, ModelViewTransform modelViewTransform) {
            Point2D.Double double_ = new Point2D.Double(modelViewTransform.modelToViewX((double)graph.xRange.getMin() - 1.0), modelViewTransform.modelToViewY(0.0));
            Point2D.Double double_2 = new Point2D.Double(modelViewTransform.modelToViewX((double)graph.xRange.getMax() + 1.0), modelViewTransform.modelToViewY(0.0));
            DoubleArrowNode doubleArrowNode = new DoubleArrowNode(double_, double_2, AXIS_ARROW_SIZE.getHeight(), AXIS_ARROW_SIZE.getWidth(), 1.0);
            doubleArrowNode.setPaint(AXIS_COLOR);
            doubleArrowNode.setStroke(null);
            this.addChild(doubleArrowNode);
            PText pText = new PText(LGResources.Strings.SYMBOL_X);
            this.addChild(pText);
            pText.setFont(AXIS_LABEL_FONT);
            pText.setOffset(doubleArrowNode.getFullBoundsReference().getMaxX() + 2.0, doubleArrowNode.getFullBoundsReference().getCenterY() - pText.getFullBoundsReference().getHeight() / 2.0);
            int n = graph.getWidth() + 1;
            for (int i = 0; i < n; ++i) {
                int n2 = graph.xRange.getMin() + i;
                if (n2 == 0) continue;
                double d = modelViewTransform.modelToViewX(n2);
                double d2 = modelViewTransform.modelToViewY(0.0);
                if (Math.abs(n2) % 5 == 0) {
                    this.addChild(new MajorTickNode(d, d2, n2, true));
                    continue;
                }
                this.addChild(new MinorTickNode(d, d2, true));
            }
        }
    }

    private static class YAxisNode
    extends PComposite {
        public YAxisNode(Graph graph, ModelViewTransform modelViewTransform) {
            Point2D.Double double_ = new Point2D.Double(modelViewTransform.modelToViewX(0.0), modelViewTransform.modelToViewY((double)graph.yRange.getMin() - 1.0));
            Point2D.Double double_2 = new Point2D.Double(modelViewTransform.modelToViewX(0.0), modelViewTransform.modelToViewY((double)graph.yRange.getMax() + 1.0));
            DoubleArrowNode doubleArrowNode = new DoubleArrowNode(double_, double_2, AXIS_ARROW_SIZE.getHeight(), AXIS_ARROW_SIZE.getWidth(), 1.0);
            doubleArrowNode.setPaint(AXIS_COLOR);
            doubleArrowNode.setStroke(null);
            this.addChild(doubleArrowNode);
            PText pText = new PText(LGResources.Strings.SYMBOL_Y);
            this.addChild(pText);
            pText.setFont(AXIS_LABEL_FONT);
            pText.setOffset(doubleArrowNode.getFullBoundsReference().getCenterX() - pText.getFullBoundsReference().getWidth() / 2.0, doubleArrowNode.getFullBoundsReference().getMinY() - pText.getFullBoundsReference().getHeight() - 2.0);
            int n = graph.getHeight() + 1;
            for (int i = 0; i < n; ++i) {
                int n2 = graph.yRange.getMin() + i;
                if (n2 == 0) continue;
                double d = modelViewTransform.modelToViewX(0.0);
                double d2 = modelViewTransform.modelToViewY(n2);
                if (Math.abs(n2) % 5 == 0) {
                    this.addChild(new MajorTickNode(d, d2, n2, false));
                    continue;
                }
                this.addChild(new MinorTickNode(d, d2, false));
            }
        }
    }
}

