/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.linegraphing.common.model;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.ObservableList;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.linegraphing.common.model.Line;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PointTool
implements Resettable {
    public final Property<Vector2D> location;
    public final Orientation orientation;
    public final Property<Line> onLine;
    private final ObservableList<Line> lines;

    public PointTool(Vector2D vector2D, Orientation orientation, ObservableList<Line> observableList) {
        this.location = new Property<Vector2D>(vector2D);
        this.orientation = orientation;
        this.onLine = new Property<Object>(null);
        this.lines = observableList;
        this.location.addObserver(new SimpleObserver(){

            public void update() {
                PointTool.this.updateOnLine();
            }
        });
        VoidFunction1<Line> voidFunction1 = new VoidFunction1<Line>(){

            @Override
            public void apply(Line line) {
                PointTool.this.updateOnLine();
            }
        };
        observableList.addElementAddedObserver(voidFunction1);
        observableList.addElementRemovedObserver(voidFunction1);
    }

    private void updateOnLine() {
        for (int i = this.lines.size() - 1; i >= 0; --i) {
            Line line = this.lines.get(i);
            if (!this.isOnLine(line)) continue;
            this.onLine.set(line);
            return;
        }
        this.onLine.set(null);
    }

    private boolean isOnLine(Line line) {
        if (line.run == 0.0 && this.location.get().getX() == line.x1) {
            return true;
        }
        if (line.rise == 0.0 && this.location.get().getY() == line.y1) {
            return true;
        }
        return line.run != 0.0 && line.rise != 0.0 && this.location.get().getY() == line.solveY(this.location.get().getX());
    }

    @Override
    public void reset() {
        this.location.reset();
        this.onLine.reset();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Orientation
    extends Enum<Orientation> {
        public static final /* enum */ Orientation UP = new Orientation();
        public static final /* enum */ Orientation DOWN = new Orientation();
        private static final /* synthetic */ Orientation[] $VALUES;

        public static Orientation[] values() {
            return (Orientation[])$VALUES.clone();
        }

        static {
            $VALUES = new Orientation[]{UP, DOWN};
        }
    }
}

