/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.linegraphing.common.model;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.ObservableList;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.linegraphing.common.LGConstants;
import edu.colorado.phet.linegraphing.common.model.Graph;
import edu.colorado.phet.linegraphing.common.model.Line;
import edu.colorado.phet.linegraphing.common.model.PointTool;
import java.awt.geom.Point2D;

public abstract class LineFormsModel
implements Resettable {
    private static final Point2D ORIGIN_OFFSET = new Point2D.Double(305.0, 320.0);
    public final Graph graph = new Graph(LGConstants.X_AXIS_RANGE, LGConstants.Y_AXIS_RANGE);
    public final ModelViewTransform mvt;
    public final Property<Line> interactiveLine;
    public final ObservableList<Line> savedLines;
    public final ObservableList<Line> standardLines;
    public final PointTool pointTool1;
    public final PointTool pointTool2;

    protected LineFormsModel(Line line) {
        double d = 530 / Math.max(this.graph.xRange.getLength(), this.graph.yRange.getLength());
        this.mvt = ModelViewTransform.createOffsetScaleMapping(ORIGIN_OFFSET, d, -d);
        this.interactiveLine = new Property<Line>(line);
        this.savedLines = new ObservableList();
        this.standardLines = new ObservableList();
        VoidFunction1<Line> voidFunction1 = new VoidFunction1<Line>(){

            @Override
            public void apply(Line line) {
                LineFormsModel.this.graph.lines.clear();
                LineFormsModel.this.graph.lines.add(LineFormsModel.this.interactiveLine.get());
                for (Line line2 : LineFormsModel.this.savedLines) {
                    LineFormsModel.this.graph.lines.add(line2);
                }
                for (Line line2 : LineFormsModel.this.standardLines) {
                    LineFormsModel.this.graph.lines.add(line2);
                }
            }
        };
        this.interactiveLine.addObserver(voidFunction1);
        this.savedLines.addElementAddedObserver(voidFunction1);
        this.savedLines.addElementRemovedObserver(voidFunction1);
        this.standardLines.addElementAddedObserver(voidFunction1);
        this.standardLines.addElementRemovedObserver(voidFunction1);
        this.pointTool1 = new PointTool(new Vector2D((double)this.graph.xRange.getMin() + 0.35 * (double)this.graph.xRange.getLength(), (double)this.graph.yRange.getMin() - 0.25), PointTool.Orientation.UP, this.graph.lines);
        this.pointTool2 = new PointTool(new Vector2D((double)this.graph.xRange.getMin() + 0.65 * (double)this.graph.xRange.getLength(), (double)this.graph.yRange.getMin() - 2.75), PointTool.Orientation.DOWN, this.graph.lines);
    }

    public void reset() {
        this.interactiveLine.reset();
        this.savedLines.clear();
        this.standardLines.clear();
        this.pointTool1.reset();
        this.pointTool2.reset();
    }
}

