/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.games;

import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.model.property.Property;

public class GameTimer {
    public final Property<Long> time;
    private final IClock clock = new ConstantDtClock(200, 1.0);
    private long startTime;

    public GameTimer() {
        this.time = new Property<Long>(0L);
        this.clock.addClockListener(new ClockAdapter(){

            public void clockTicked(ClockEvent clockEvent) {
                GameTimer.this.time.set(clockEvent.getWallTime() - GameTimer.this.startTime);
            }
        });
    }

    public boolean isRunning() {
        return this.clock.isRunning();
    }

    public void start() {
        this.time.set(0L);
        this.startTime = System.currentTimeMillis();
        this.clock.start();
    }

    public void stop() {
        if (this.isRunning()) {
            this.clock.pause();
        }
    }
}

