/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.recordandplayback.gui;

import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.recordandplayback.model.RecordAndPlaybackModel;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Color;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlaybackSpeedSlider<T>
extends PNode {
    private RecordAndPlaybackModel<T> model;

    public PlaybackSpeedSlider(final RecordAndPlaybackModel<T> recordAndPlaybackModel) {
        this.model = recordAndPlaybackModel;
        this.addInputEventListener(new CursorHandler());
        final JSlider jSlider = new JSlider();
        jSlider.setBackground(new Color(0, 0, 0, 0));
        final Function.LinearFunction linearFunction = new Function.LinearFunction(jSlider.getMinimum(), jSlider.getMaximum(), 0.25, 2.0);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        hashtable.put(jSlider.getMinimum(), new JLabel(PhetCommonResources.getString("Common.time.slow")));
        hashtable.put(jSlider.getMaximum(), new JLabel(PhetCommonResources.getString("Common.time.fast")));
        jSlider.setLabelTable(hashtable);
        jSlider.setPaintLabels(true);
        PSwing pSwing = new PSwing(jSlider);
        this.addChild(pSwing);
        jSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                recordAndPlaybackModel.setPlaybackSpeed(linearFunction.evaluate(jSlider.getValue()));
            }
        });
        SimpleObserver simpleObserver = new SimpleObserver(){

            public void update() {
                jSlider.setValue((int)linearFunction.createInverse().evaluate(recordAndPlaybackModel.getPlaybackSpeed()));
                PlaybackSpeedSlider.this.setVisible(recordAndPlaybackModel.isPlayback());
            }
        };
        recordAndPlaybackModel.addObserver(simpleObserver);
        simpleObserver.update();
    }
}

