/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.ladybugmotion2d.model;

import edu.colorado.phet.common.motion.MotionMath;
import edu.colorado.phet.common.motion.model.TimeData;
import edu.colorado.phet.ladybugmotion2d.LadybugDefaults$;
import edu.colorado.phet.ladybugmotion2d.Motion2DModel;
import edu.colorado.phet.ladybugmotion2d.model.Ladybug;
import edu.colorado.phet.ladybugmotion2d.model.LadybugModel$AccelerationMode$;
import edu.colorado.phet.ladybugmotion2d.model.LadybugModel$PositionMode$;
import edu.colorado.phet.ladybugmotion2d.model.LadybugModel$VelocityMode$;
import edu.colorado.phet.ladybugmotion2d.model.LadybugMotionModel;
import edu.colorado.phet.ladybugmotion2d.model.LadybugMotionModel$;
import edu.colorado.phet.ladybugmotion2d.model.LadybugState;
import edu.colorado.phet.recordandplayback.model.DataPoint;
import edu.colorado.phet.recordandplayback.model.RecordAndPlaybackModel;
import edu.colorado.phet.scalacommon.math.Vector2D;
import edu.colorado.phet.scalacommon.util.Observable;
import edu.colorado.phet.scalacommon.util.Observable$class;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.Product$class;
import scala.Serializable;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ClassManifest$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LadybugModel
extends RecordAndPlaybackModel<LadybugState>
implements Observable {
    private final Ladybug ladybug;
    private final LadybugMotionModel ladybugMotionModel;
    private Rectangle2D.Double bounds;
    private UpdateMode updateMode;
    private final ArrayBuffer<Function0<BoxedUnit>> tickListeners;
    private final ArrayBuffer<Function0<BoxedUnit>> resetListeners;
    private boolean frictionless;
    private final Motion2DModel motion2DModel;
    private final ArrayBuffer<DataPoint<LadybugState>> modelHistory;
    private double dt;
    private final ArrayBuffer<PenSample> penPath;
    private Vector2D penPoint;
    private boolean penDown;
    private volatile LadybugModel$PositionMode$ PositionMode$module;
    private volatile LadybugModel$VelocityMode$ VelocityMode$module;
    private volatile LadybugModel$AccelerationMode$ AccelerationMode$module;
    private final ArrayBuffer<Function0<BoxedUnit>> edu$colorado$phet$scalacommon$util$Observable$$listeners;

    @Override
    public LadybugState step(double simulationTimeChange) {
        return this.stepRecord(LadybugDefaults$.MODULE$.defaultDT());
    }

    public Ladybug ladybug() {
        return this.ladybug;
    }

    private LadybugMotionModel ladybugMotionModel() {
        return this.ladybugMotionModel;
    }

    private Rectangle2D.Double bounds() {
        return this.bounds;
    }

    private UpdateMode updateMode() {
        return this.updateMode;
    }

    private void updateMode_$eq(UpdateMode updateMode) {
        this.updateMode = updateMode;
    }

    public ArrayBuffer<Function0<BoxedUnit>> tickListeners() {
        return this.tickListeners;
    }

    public ArrayBuffer<Function0<BoxedUnit>> resetListeners() {
        return this.resetListeners;
    }

    private boolean frictionless() {
        return this.frictionless;
    }

    private void frictionless_$eq(boolean bl) {
        this.frictionless = bl;
    }

    public Motion2DModel motion2DModel() {
        return this.motion2DModel;
    }

    private ArrayBuffer<DataPoint<LadybugState>> modelHistory() {
        return this.modelHistory;
    }

    public ArrayBuffer<PenSample> penPath() {
        return this.penPath;
    }

    private Vector2D penPoint() {
        return this.penPoint;
    }

    private void penPoint_$eq(Vector2D vector2D) {
        this.penPoint = vector2D;
    }

    private boolean penDown() {
        return this.penDown;
    }

    private void penDown_$eq(boolean bl) {
        this.penDown = bl;
    }

    public boolean isFrictionless() {
        return this.frictionless();
    }

    public void setFrictionless(boolean f) {
        if (this.frictionless() != f) {
            this.frictionless_$eq(f);
            if (this.frictionless()) {
                this.clearSampleHistory();
                this.resetMotion2DModel();
                this.penPoint_$eq(this.ladybug().getPosition());
            } else {
                this.clearSampleHistory();
                this.resetMotion2DModel();
                this.penPoint_$eq(this.ladybug().getPosition());
            }
            this.notifyObserversAndListeners();
        }
    }

    public void notifyObserversAndListeners() {
        this.notifyObservers();
        this.notifyListeners();
    }

    public void setSamplePoint(Point2D pt) {
        this.penPoint_$eq(edu.colorado.phet.scalacommon.Predef$.MODULE$.pointToVector2D(pt));
    }

    public Rectangle2D getBounds() {
        return new Rectangle2D.Double(this.bounds().getX(), this.bounds().getY(), this.bounds().getWidth(), this.bounds().getHeight());
    }

    public void setBounds(Rectangle2D b) {
        this.bounds().setRect(b.getX(), b.getY(), b.getWidth(), b.getHeight());
    }

    public LadybugMotionModel getLadybugMotionModel() {
        return this.ladybugMotionModel();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final LadybugModel$PositionMode$ PositionMode() {
        if (this.PositionMode$module != null) return this.PositionMode$module;
        LadybugModel ladybugModel = this;
        synchronized (ladybugModel) {
            if (this.PositionMode$module == null) {
                this.PositionMode$module = new LadybugModel$PositionMode$(this);
            }
            return this.PositionMode$module;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final LadybugModel$VelocityMode$ VelocityMode() {
        if (this.VelocityMode$module != null) return this.VelocityMode$module;
        LadybugModel ladybugModel = this;
        synchronized (ladybugModel) {
            if (this.VelocityMode$module == null) {
                this.VelocityMode$module = new LadybugModel$VelocityMode$(this);
            }
            return this.VelocityMode$module;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final LadybugModel$AccelerationMode$ AccelerationMode() {
        if (this.AccelerationMode$module != null) return this.AccelerationMode$module;
        LadybugModel ladybugModel = this;
        synchronized (ladybugModel) {
            if (this.AccelerationMode$module == null) {
                this.AccelerationMode$module = new LadybugModel$AccelerationMode$(this);
            }
            return this.AccelerationMode$module;
        }
    }

    public void setUpdateModePosition() {
        UpdateMode updateMode = this.updateMode();
        LadybugModel$PositionMode$ ladybugModel$PositionMode$ = this.PositionMode();
        if (updateMode == null ? ladybugModel$PositionMode$ != null : !updateMode.equals(ladybugModel$PositionMode$)) {
            this.updateMode_$eq(this.PositionMode());
            this.clearSampleHistory();
            this.resetMotion2DModel();
        }
    }

    public void setUpdateModeVelocity() {
        UpdateMode updateMode = this.updateMode();
        LadybugModel$VelocityMode$ ladybugModel$VelocityMode$ = this.VelocityMode();
        if (updateMode == null ? ladybugModel$VelocityMode$ != null : !updateMode.equals(ladybugModel$VelocityMode$)) {
            this.updateMode_$eq(this.VelocityMode());
        }
    }

    public void setUpdateModeAcceleration() {
        this.updateMode_$eq(this.AccelerationMode());
    }

    private PenSample getLastSamplePoint() {
        return (PenSample)this.penPath().apply(this.penPath().length() - 1);
    }

    public void positionMode(double dt) {
        if (this.frictionless() && !this.penDown()) {
            this.velocityMode(dt);
            if (this.penPath().length() > 2) {
                this.penPoint_$eq(this.ladybug().getPosition());
                this.penPath().$plus$eq((Object)new PenSample(this, this.getTime(), this.penPoint()));
                this.motion2DModel().addPointAndUpdate(this.getLastSamplePoint().location().x(), this.getLastSamplePoint().location().y());
            }
        } else {
            if (this.penPath().length() > 2) {
                this.motion2DModel().addPointAndUpdate(this.getLastSamplePoint().location().x(), this.getLastSamplePoint().location().y());
                this.ladybug().setPosition(new Vector2D(this.motion2DModel().getAvgXMid(), this.motion2DModel().getAvgYMid()));
                double vscale = 1.0 / dt / (double)10;
                double ascale = vscale * vscale * 3.835;
                this.ladybug().setVelocity(new Vector2D(this.motion2DModel().getXVel(), this.motion2DModel().getYVel()).$times(vscale));
                this.ladybug().setAcceleration(new Vector2D(this.motion2DModel().getXAcc(), this.motion2DModel().getYAcc()).$times(ascale));
            } else {
                this.ladybug().setVelocity(new Vector2D());
                this.ladybug().setAcceleration(new Vector2D());
            }
            this.pointInDirectionOfMotion();
        }
    }

    public void pointInDirectionOfMotion() {
        if (this.estimateVelocity(this.modelHistory().length() - 1).magnitude() > 1.0E-6) {
            this.ladybug().setAngle(this.estimateAngle());
        }
    }

    public void velocityMode(double dt) {
        if (this.penPath().length() > 0) {
            this.motion2DModel().addPointAndUpdate(this.getLastSamplePoint().location().x(), this.getLastSamplePoint().location().y());
        }
        this.ladybug().translate(this.ladybug().getVelocity().$times(dt));
        Vector2D accelEstimate = this.average(this.modelHistory().length() - 15, this.modelHistory().length() - 1, (Function1<Object, Vector2D>)((Object)new Serializable(this){
            public static final long serialVersionUID;
            private final LadybugModel $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Vector2D apply(int n) {
                return this.$outer.estimateAcceleration(n);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        this.ladybug().setAcceleration(accelEstimate);
        this.pointInDirectionOfMotion();
    }

    public void accelerationMode(double dt) {
        this.ladybug().translate(this.ladybug().getVelocity().$times(dt));
        this.ladybug().setVelocity(this.ladybug().getVelocity().$plus(this.ladybug().getAcceleration().$times(dt)));
        this.pointInDirectionOfMotion();
    }

    @Override
    public void setPlaybackState(LadybugState state) {
        this.ladybug().setState(state);
    }

    public LadybugState stepRecord(double dt) {
        this.tickListeners().foreach(new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Function0<BoxedUnit> function0) {
                function0.apply$mcV$sp();
            }
        });
        if (this.isRecord()) {
            this.ladybugMotionModel().update(dt, this);
            this.modelHistory().$plus$eq((Object)new DataPoint<LadybugState>(this.getTime(), this.ladybug().getState()));
            this.penPath().$plus$eq((Object)new PenSample(this, this.getTime(), this.penPoint()));
            while (this.modelHistory().length() > 100) {
                this.modelHistory().remove(0);
            }
            while (this.penPath().length() > 100) {
                this.penPath().remove(0);
            }
            while (this.getNumRecordedPoints() > this.getMaxRecordPoints()) {
                this.removeHistoryPoint(0);
            }
            if (!this.ladybugMotionModel().isExclusive()) {
                if (this.penDown()) {
                    this.PositionMode().update(dt);
                } else {
                    this.updateMode().update(dt);
                }
            }
            this.notifyObserversAndListeners();
        }
        return this.ladybug().getState();
    }

    public void initManual() {
        this.resetMotion2DModel();
        this.penPath().clear();
    }

    public boolean readyForInteraction() {
        boolean recording = this.isRecord();
        boolean isDonePlayback = this.getTime() >= this.getMaxRecordedTime() - 1.0 && this.isPaused();
        return recording || isDonePlayback;
    }

    public double estimateAngle() {
        return this.estimateVelocity(this.modelHistory().length() - 1).angle();
    }

    public Vector2D estimateVelocity(int index) {
        ArrayBuffer h = (ArrayBuffer)this.modelHistory().slice(this.modelHistory().length() - 6, this.modelHistory().length());
        ArrayBuffer tx = h.map(new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final TimeData apply(DataPoint<LadybugState> item) {
                return new TimeData(item.getState().position().x(), item.getTime());
            }
        }, ArrayBuffer$.MODULE$.canBuildFrom());
        double vx = MotionMath.estimateDerivative((TimeData[])tx.toArray(ClassManifest$.MODULE$.classType(TimeData.class)));
        ArrayBuffer ty = h.map(new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final TimeData apply(DataPoint<LadybugState> item) {
                return new TimeData(item.getState().position().y(), item.getTime());
            }
        }, ArrayBuffer$.MODULE$.canBuildFrom());
        double vy = MotionMath.estimateDerivative((TimeData[])ty.toArray(ClassManifest$.MODULE$.classType(TimeData.class)));
        return new Vector2D(vx, vy);
    }

    public Vector2D estimateAcceleration(int index) {
        ArrayBuffer h = (ArrayBuffer)this.modelHistory().slice(this.modelHistory().length() - 6, this.modelHistory().length());
        ArrayBuffer tx = h.map(new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final TimeData apply(DataPoint<LadybugState> item) {
                return new TimeData(item.getState().velocity().x(), item.getTime());
            }
        }, ArrayBuffer$.MODULE$.canBuildFrom());
        double ax = MotionMath.estimateDerivative((TimeData[])tx.toArray(ClassManifest$.MODULE$.classType(TimeData.class)));
        ArrayBuffer ty = h.map(new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final TimeData apply(DataPoint<LadybugState> item) {
                return new TimeData(item.getState().velocity().y(), item.getTime());
            }
        }, ArrayBuffer$.MODULE$.canBuildFrom());
        double ay = MotionMath.estimateDerivative((TimeData[])ty.toArray(ClassManifest$.MODULE$.classType(TimeData.class)));
        return new Vector2D(ax, ay);
    }

    public Vector2D average(int start, int end, Function1<Object, Vector2D> function$1) {
        ObjectRef sum$1 = new ObjectRef(new Vector2D());
        Predef$.MODULE$.intWrapper(start).until(end).foreach$mVc$sp((Function1<Object, BoxedUnit>)((Object)new Serializable(this, function$1, sum$1){
            public static final long serialVersionUID;
            private final Function1 function$1;
            private final ObjectRef sum$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int v1) {
                this.sum$1.elem = ((Vector2D)this.sum$1.elem).$plus((Vector2D)this.function$1.apply(BoxesRunTime.boxToInteger(v1)));
            }
            {
                this.function$1 = function1;
                this.sum$1 = objectRef;
            }
        }));
        return ((Vector2D)sum$1.elem).$div(end - start);
    }

    @Override
    public void handleRecordStartedDuringPlayback() {
        if (this.ladybug() != null) {
            this.ladybug().setVelocity(new Vector2D());
            this.ladybug().setAcceleration(new Vector2D());
        }
    }

    @Override
    public void clearHistoryRemainder() {
        super.clearHistoryRemainder();
        if (this.modelHistory() != null) {
            ArrayBuffer earlyEnough = (ArrayBuffer)this.modelHistory().filter((Function1<DataPoint<LadybugState>, Object>)((Object)new Serializable(this){
                public static final long serialVersionUID;
                private final LadybugModel $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final boolean apply(DataPoint<LadybugState> dataPoint) {
                    return dataPoint.getTime() < this.$outer.getTime();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }));
            this.modelHistory().clear();
            this.modelHistory().appendAll(earlyEnough);
            this.clearSampleHistory();
            this.resetMotion2DModel();
        }
    }

    @Override
    public void startRecording() {
        super.startRecording();
        this.getLadybugMotionModel().motion_$eq(LadybugMotionModel$.MODULE$.MANUAL());
    }

    @Override
    public void resetAll() {
        super.resetAll();
        if (this.modelHistory() != null) {
            this.modelHistory().clear();
            this.penPath().clear();
            this.ladybugMotionModel().resetAll();
            this.ladybug().resetAll();
            this.frictionless_$eq(false);
            this.resetMotion2DModel();
            this.notifyObserversAndListeners();
        }
    }

    @Override
    public void clearHistory() {
        if (this.modelHistory() != null) {
            this.modelHistory().clear();
        }
        if (this.penPath() != null) {
            this.penPath().clear();
        }
        super.clearHistory();
    }

    public void clearSampleHistory() {
        this.penPath().clear();
    }

    public void resetMotion2DModel() {
        this.motion2DModel().reset(this.ladybug().getPosition().x(), this.ladybug().getPosition().y());
        this.resetListeners().foreach(new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Function0<BoxedUnit> function0) {
                function0.apply$mcV$sp();
            }
        });
    }

    public void returnLadybug() {
        this.ladybug().setPosition(LadybugDefaults$.MODULE$.defaultLocation());
        this.ladybug().setVelocity(new Vector2D());
        this.penPath().clear();
        this.setSamplePoint(edu.colorado.phet.scalacommon.Predef$.MODULE$.vector2DToPoint(this.ladybug().getPosition()));
        this.resetMotion2DModel();
        this.notifyObserversAndListeners();
    }

    public void setPenDown(boolean p) {
        this.penDown_$eq(p);
        this.notifyObserversAndListeners();
    }

    public LadybugModel() {
        super((int)(LadybugDefaults$.MODULE$.timelineLengthSeconds() / LadybugDefaults$.MODULE$.defaultDT()));
        Observable$class.$init$(this);
        this.ladybug = new Ladybug();
        this.ladybugMotionModel = new LadybugMotionModel(this);
        this.bounds = new Rectangle2D.Double(-10.0, -10.0, 20.0, 20.0);
        this.updateMode = this.PositionMode();
        this.tickListeners = new ArrayBuffer();
        this.resetListeners = new ArrayBuffer();
        this.frictionless = false;
        this.motion2DModel = new Motion2DModel(10, 5, LadybugDefaults$.MODULE$.defaultLocation().x(), LadybugDefaults$.MODULE$.defaultLocation().y());
        this.modelHistory = new ArrayBuffer();
        this.dt = 0.0;
        this.penPath = new ArrayBuffer();
        this.penPoint = new Vector2D();
        this.penDown = false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PenSample
    implements Product,
    Serializable {
        private final double time;
        private final Vector2D location;
        public final LadybugModel $outer;

        public double time() {
            return this.time;
        }

        public Vector2D location() {
            return this.location;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            Vector2D vector2D;
            Vector2D location$1;
            if (this == object) return true;
            Object object2 = object;
            if (!(object2 instanceof PenSample)) return false;
            if (((PenSample)object2).edu$colorado$phet$ladybugmotion2d$model$LadybugModel$PenSample$$$outer() != this.edu$colorado$phet$ladybugmotion2d$model$LadybugModel$PenSample$$$outer()) return false;
            PenSample penSample = (PenSample)object2;
            double d = penSample.time();
            double time$1 = d;
            if (!this.gd1$1(time$1, location$1 = (vector2D = penSample.location()))) return false;
            boolean bl = ((PenSample)object).canEqual(this);
            if (!bl) return false;
            return true;
        }

        @Override
        public String productPrefix() {
            return "PenSample";
        }

        @Override
        public int productArity() {
            return 2;
        }

        @Override
        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger(n)).toString());
                }
                case 0: {
                    object = BoxesRunTime.boxToDouble(this.time());
                    break;
                }
                case 1: {
                    object = this.location();
                }
            }
            return object;
        }

        @Override
        public boolean canEqual(Object object) {
            return object instanceof PenSample;
        }

        public LadybugModel edu$colorado$phet$ladybugmotion2d$model$LadybugModel$PenSample$$$outer() {
            return this.$outer;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean gd1$1(double d, Vector2D vector2D) {
            if (d != this.time()) return false;
            Vector2D vector2D2 = vector2D;
            Vector2D vector2D3 = this.location();
            if (vector2D2 != null) {
                if (!((Object)vector2D2).equals(vector2D3)) return false;
                return true;
            }
            if (vector2D3 == null) return true;
            return false;
        }

        public PenSample(LadybugModel $outer, double time, Vector2D location) {
            this.time = time;
            this.location = location;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            Product$class.$init$(this);
        }
    }

    public abstract class UpdateMode {
        public final LadybugModel $outer;

        public abstract void update(double var1);

        public UpdateMode(LadybugModel $outer) {
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }
    }
}

