/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.ladybugmotion2d.aphidmaze;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.view.util.RectangleUtils;
import edu.colorado.phet.ladybugmotion2d.aphidmaze.MazeGenerator;
import edu.colorado.phet.ladybugmotion2d.aphidmaze.Wall;
import edu.colorado.phet.ladybugmotion2d.model.Ladybug;
import edu.colorado.phet.scalacommon.math.Vector2D;
import edu.colorado.phet.scalacommon.util.Observable;
import edu.colorado.phet.scalacommon.util.Observable$class;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ClassManifest$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BarrierSet
implements Observable {
    private final ArrayBuffer<Rectangle2D> rectangles;
    private final ArrayBuffer<Line2D.Double> lines;
    private int _dim;
    private final ArrayBuffer<Function0<BoxedUnit>> edu$colorado$phet$scalacommon$util$Observable$$listeners;

    public ArrayBuffer<Line2D.Double> lines() {
        return this.lines;
    }

    private int _dim() {
        return this._dim;
    }

    private void _dim_$eq(int n) {
        this._dim = n;
    }

    public int getDim() {
        return this._dim();
    }

    public Rectangle2D getBounds() {
        ArrayBuffer lineBounds = this.lines().map(new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Rectangle2D apply(Line2D.Double line) {
                return line.getBounds2D();
            }
        }, ArrayBuffer$.MODULE$.canBuildFrom());
        Rectangle2D bounds = RectangleUtils.union((Rectangle2D[])lineBounds.toArray(ClassManifest$.MODULE$.classType(Rectangle2D.class)));
        return bounds == null ? new Rectangle2D.Double(0.0, 0.0, 1.0, 1.0) : bounds;
    }

    public void update(Ladybug ladybug) {
    }

    public boolean crossedBarrier(Vector2D start$1, Vector2D end$1) {
        return BoxesRunTime.unboxToBoolean(this.lines().foldLeft(BoxesRunTime.boxToBoolean(false), new Serializable(this, start$1, end$1){
            public static final long serialVersionUID;
            private final BarrierSet $outer;
            private final Vector2D start$1;
            private final Vector2D end$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(boolean value, Line2D.Double cur) {
                return this.$outer.crossed(cur, this.start$1, this.end$1) || value;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.start$1 = vector2D;
                this.end$1 = vector2D2;
            }
        }));
    }

    public boolean crossed(Line2D.Double line, Vector2D start, Vector2D end) {
        Point2D.Double intersection = MathUtil.getLineSegmentsIntersection(line, new Line2D.Double(edu.colorado.phet.scalacommon.Predef$.MODULE$.vector2DToPoint(start), edu.colorado.phet.scalacommon.Predef$.MODULE$.vector2DToPoint(end)));
        return !Predef$.MODULE$.double2Double(intersection.getX()).isNaN();
    }

    public void setDim(int dim) {
        if (dim != this._dim()) {
            this.lines().clear();
            MazeGenerator mg = new MazeGenerator(dim);
            mg.walls().foreach(new Serializable(this){
                public static final long serialVersionUID;
                private final BarrierSet $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final ArrayBuffer<Line2D.Double> apply(Wall w) {
                    return this.$outer.lines().$plus$eq((Object)this.$outer.toLine(w));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            this._dim_$eq(dim);
            this.notifyListeners();
        }
    }

    public Line2D.Double toLine(Wall w) {
        return new Line2D.Double(w.x(), w.y(), w.x() + w.dx(), w.y() + w.dy());
    }

    public BarrierSet() {
        Observable$class.$init$(this);
        this.rectangles = new ArrayBuffer();
        this.lines = new ArrayBuffer();
        this._dim = 0;
        this.setDim(10);
    }
}

