/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.math;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.Random;

public class MathUtil {
    private static final Random random = new Random(System.currentTimeMillis());
    public static final double SQRT_2 = Math.sqrt(2.0);

    public static Point2D.Double getLineSegmentsIntersection(Line2D line2D, Line2D line2D2) {
        return MathUtil.getLineSegmentsIntersection(line2D.getP1(), line2D.getP2(), line2D2.getP1(), line2D2.getP2());
    }

    public static Point2D.Double getLineSegmentsIntersection(Point2D point2D, Point2D point2D2, Point2D point2D3, Point2D point2D4) {
        Point2D.Double double_ = new Point2D.Double();
        double d = point2D.getX();
        double d2 = point2D.getY();
        double d3 = point2D2.getX();
        double d4 = point2D2.getY();
        double d5 = point2D3.getX();
        double d6 = point2D3.getY();
        double d7 = point2D4.getX();
        double d8 = point2D4.getY();
        double d9 = (d7 - d5) * (d2 - d6) - (d8 - d6) * (d - d5);
        double d10 = (d3 - d) * (d2 - d6) - (d4 - d2) * (d - d5);
        double d11 = (d8 - d6) * (d3 - d) - (d7 - d5) * (d4 - d2);
        if (d11 == 0.0) {
            double_.setLocation(Double.NaN, Double.NaN);
        } else {
            double d12 = d9 / d11;
            double d13 = d10 / d11;
            if (!(d12 >= 0.0 && d12 <= 1.0 && d13 >= 0.0 && d13 <= 1.0)) {
                double_.setLocation(Double.NaN, Double.NaN);
            } else {
                double d14 = d + d12 * (d3 - d);
                double d15 = d2 + d12 * (d4 - d2);
                double_.setLocation(d14, d15);
            }
        }
        return double_;
    }

    public static double clamp(double d, double d2, double d3) {
        if (Double.isNaN(d) || Double.isNaN(d2) || Double.isNaN(d3)) {
            return Double.NaN;
        }
        if (d2 < d) {
            return d;
        }
        if (d2 > d3) {
            return d3;
        }
        return d2;
    }

    public static long daysToMilliseconds(long l) {
        return l * 24L * 60L * 60L * 1000L;
    }
}

