/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.vectors;

import JSci.maths.ExtraMath;
import JSci.maths.vectors.AbstractDoubleVector;
import JSci.maths.vectors.MathVector;
import JSci.maths.vectors.VectorDimensionException;

public class DoubleVector
extends AbstractDoubleVector {
    protected double[] vector;

    public DoubleVector(double[] dArray) {
        super(dArray.length);
        this.vector = dArray;
    }

    public boolean equals(Object object, double d) {
        if (object != null && object instanceof AbstractDoubleVector && this.N == ((AbstractDoubleVector)object).N) {
            AbstractDoubleVector abstractDoubleVector = (AbstractDoubleVector)object;
            double d2 = 0.0;
            for (int i = 0; i < this.N; ++i) {
                double d3 = this.vector[i] - abstractDoubleVector.getComponent(i);
                d2 += d3 * d3;
            }
            return d2 <= d * d;
        }
        return false;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer(8 * this.N);
        for (n = 0; n < this.N - 1; ++n) {
            stringBuffer.append(this.vector[n]);
            stringBuffer.append(',');
        }
        stringBuffer.append(this.vector[n]);
        return stringBuffer.toString();
    }

    public double getComponent(int n) {
        if (n >= 0 && n < this.N) {
            return this.vector[n];
        }
        throw new VectorDimensionException(MathVector.getInvalidComponentMsg(n));
    }

    public double norm() {
        double d = this.vector[0];
        for (int i = 1; i < this.N; ++i) {
            d = ExtraMath.hypot(d, this.vector[i]);
        }
        return d;
    }

    public AbstractDoubleVector subtract(AbstractDoubleVector abstractDoubleVector) {
        if (abstractDoubleVector instanceof DoubleVector) {
            return this.subtract((DoubleVector)abstractDoubleVector);
        }
        if (this.N == abstractDoubleVector.N) {
            double[] dArray = new double[this.N];
            dArray[0] = this.vector[0] - abstractDoubleVector.getComponent(0);
            for (int i = 1; i < this.N; ++i) {
                dArray[i] = this.vector[i] - abstractDoubleVector.getComponent(i);
            }
            return new DoubleVector(dArray);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public DoubleVector subtract(DoubleVector doubleVector) {
        if (this.N == doubleVector.N) {
            double[] dArray = new double[this.N];
            dArray[0] = this.vector[0] - doubleVector.vector[0];
            for (int i = 1; i < this.N; ++i) {
                dArray[i] = this.vector[i] - doubleVector.vector[i];
            }
            return new DoubleVector(dArray);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }
}

