/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessControlException;
import java.util.Properties;

public class AbstractPropertiesFile {
    private final File file;
    private final Properties properties;
    private String header;

    public AbstractPropertiesFile(File file) {
        this.file = file;
        this.header = null;
        this.properties = AbstractPropertiesFile.load(file);
    }

    private static Properties load(File file) {
        Properties properties = new Properties();
        if (file.exists()) {
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                properties.load(bufferedInputStream);
                bufferedInputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (AccessControlException accessControlException) {
                System.err.println(AbstractPropertiesFile.class.getName() + " access denied to file " + file.getAbsolutePath());
            }
        }
        return properties;
    }

    private void store() {
        try {
            File file = this.file.getParentFile();
            if (!file.exists()) {
                file.mkdirs();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(this.file);
            this.properties.store(fileOutputStream, this.header);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (AccessControlException accessControlException) {
            System.err.println(this.getClass().getName() + " access denied to file " + this.file.getAbsolutePath());
        }
    }

    protected void setProperty(String string, String string2) {
        this.properties.setProperty(string, string2);
        this.store();
    }

    protected String getProperty(String string) {
        return this.properties.getProperty(string);
    }

    public String toString() {
        return this.properties.toString();
    }

    public boolean delete() {
        this.properties.clear();
        return this.file.delete();
    }

    public void deleteOnExit() {
        this.file.deleteOnExit();
    }
}

