/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.preferences;

import edu.colorado.phet.common.phetcommon.application.PhetPersistenceDir;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessControlException;
import java.util.Properties;

public class PhetPreferences {
    private static PhetPreferencesFile PREFERENCES_FILE;
    private static PhetPreferences instance;
    private final Properties properties = new Properties();

    public static void clear() {
        PREFERENCES_FILE.clear();
    }

    public static File getPreferencesFile() {
        return PREFERENCES_FILE;
    }

    private PhetPreferences() {
        if (PREFERENCES_FILE != null) {
            this.initPreferencesFile();
            try {
                this.properties.load(new FileInputStream(PREFERENCES_FILE));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private void initPreferencesFile() {
        if (!PREFERENCES_FILE.exists()) {
            PREFERENCES_FILE.getParentFile().mkdirs();
            this.setPreferencesFileCreationTimeNow();
            this.setUpdatesEnabled(true);
            this.setStatisticsEnabled(true);
            this.setAlwaysShowSoftwareAgreement(false);
        }
    }

    public static PhetPreferences getInstance() {
        if (instance == null) {
            instance = new PhetPreferences();
        }
        return instance;
    }

    public void setStatisticsEnabled(boolean bl) {
        this.setBooleanProperty("all-sims.statistics.enabled", bl);
    }

    public boolean isStatisticsEnabled() {
        return this.getBooleanProperty("all-sims.statistics.enabled");
    }

    public void setUpdatesEnabled(boolean bl) {
        this.setBooleanProperty("all-sims.updates.enabled", bl);
    }

    public boolean isUpdatesEnabled() {
        return this.getBooleanProperty("all-sims.updates.enabled");
    }

    private long setPreferencesFileCreationTimeNow() {
        long l = System.currentTimeMillis();
        this.setLongProperty("preferences-file-creation-time.milliseconds", l);
        return l;
    }

    public boolean isAlwaysShowSoftwareAgreement() {
        return this.getBooleanProperty("dev.always-show-software-agreement");
    }

    public void setAlwaysShowSoftwareAgreement(boolean bl) {
        this.setBooleanProperty("dev.always-show-software-agreement", bl);
    }

    private void setStringProperty(String string, String string2) {
        this.properties.setProperty(string, string2);
        this.storePreferences();
    }

    private String getStringProperty(String string) {
        return this.properties.getProperty(string);
    }

    private void setBooleanProperty(String string, boolean bl) {
        this.setStringProperty(string, String.valueOf(bl));
    }

    private boolean getBooleanProperty(String string) {
        return Boolean.valueOf(this.getStringProperty(string));
    }

    private void setLongProperty(String string, long l) {
        this.setStringProperty(string, String.valueOf(l));
    }

    private void storePreferences() {
        if (PREFERENCES_FILE != null) {
            try {
                this.properties.store(new FileOutputStream(PREFERENCES_FILE), "Preferences for PhET, see http://phet.colorado.edu");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public String toString() {
        return this.properties.toString();
    }

    static {
        try {
            PREFERENCES_FILE = new PhetPreferencesFile();
        }
        catch (AccessControlException accessControlException) {
            PREFERENCES_FILE = null;
            System.out.println("PhetPreferences: access to local filesystem denied");
        }
    }

    private static class PhetPreferencesFile
    extends File {
        public PhetPreferencesFile() throws AccessControlException {
            super(new PhetPersistenceDir(), "preferences.properties");
        }

        public void clear() {
            boolean bl = this.delete();
            if (!bl) {
                this.deleteOnExit();
                System.out.println("delete failed, will try again on exit");
            } else {
                System.out.println("preferences file deleted, you should probably exit now");
                PREFERENCES_FILE = null;
            }
        }
    }
}

