/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.view.monitors;

import edu.colorado.phet.common.phetcommon.application.PaintImmediateDialog;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import edu.colorado.phet.idealgas.IdealGasResources;
import edu.colorado.phet.idealgas.model.HeavySpecies;
import edu.colorado.phet.idealgas.model.IdealGasModel;
import edu.colorado.phet.idealgas.model.LightSpecies;
import edu.colorado.phet.idealgas.view.monitors.GasSpeciesMonitorPanel;
import java.awt.GridLayout;
import javax.swing.JPanel;

public class SpeciesMonitorDialog
extends PaintImmediateDialog {
    private String[] speciesPanelTitles = new String[]{IdealGasResources.getString("IdealGasMonitorPanel.Heavy_species"), IdealGasResources.getString("IdealGasMonitorPanel.Light_species")};
    private GasSpeciesMonitorPanel heavySpeciesPanel;
    private GasSpeciesMonitorPanel lightSpeciesPanel;

    public SpeciesMonitorDialog(PhetFrame phetFrame, IdealGasModel idealGasModel) {
        super(phetFrame, IdealGasResources.getString("GasSpeciesMonitorPanel.Title"), false);
        this.setResizable(false);
        JPanel jPanel = new JPanel(new GridLayout(2, 1));
        this.heavySpeciesPanel = new GasSpeciesMonitorPanel(HeavySpecies.class, this.speciesPanelTitles[0], idealGasModel);
        jPanel.add(this.heavySpeciesPanel);
        this.lightSpeciesPanel = new GasSpeciesMonitorPanel(LightSpecies.class, this.speciesPanelTitles[1], idealGasModel);
        jPanel.add(this.lightSpeciesPanel);
        this.getContentPane().add(jPanel);
        this.pack();
    }

    public void setSpeciesPanelTitles(String[] stringArray) {
        this.speciesPanelTitles = stringArray;
        this.heavySpeciesPanel.setTitle(stringArray[0]);
        this.lightSpeciesPanel.setTitle(stringArray[1]);
    }
}

