/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.view;

import edu.colorado.phet.common.phetcommon.model.clock.Clock;
import edu.colorado.phet.common.phetgraphics.view.ApparatusPanel3;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetImageGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.idealgas.IdealGasConfig;
import edu.colorado.phet.idealgas.IdealGasResources;
import edu.colorado.phet.idealgas.controller.IdealGasModule;
import edu.colorado.phet.idealgas.model.Box2D;
import edu.colorado.phet.idealgas.model.IdealGasModel;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class BaseIdealGasApparatusPanel
extends ApparatusPanel3 {
    private static boolean toolTipsSet = false;
    private PhetImageGraphic flamesGraphicImage;
    private PhetImageGraphic iceGraphicImage;
    private BufferedImage stoveImg;

    public BaseIdealGasApparatusPanel(IdealGasModule idealGasModule, Clock clock, Box2D box2D) {
        super(clock, 710, 540);
        this.init(idealGasModule, box2D);
        this.setUseOffscreenBuffer(true);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                BaseIdealGasApparatusPanel.this.requestFocus();
            }
        });
    }

    public void init(IdealGasModule idealGasModule, Box2D box2D) {
        this.setBackground(IdealGasConfig.COLOR_SCHEME.background);
        this.stoveImg = IdealGasResources.getImage("stove.png");
        Point point = new Point(277, 445);
        PhetImageGraphic phetImageGraphic = new PhetImageGraphic(this, this.stoveImg);
        phetImageGraphic.setLocation(point);
        this.addGraphic(phetImageGraphic, -4.0);
        BufferedImage bufferedImage = IdealGasResources.getImage("flames.gif");
        this.flamesGraphicImage = new PhetImageGraphic(this, bufferedImage, 290, 445);
        this.addGraphic(this.flamesGraphicImage, -6.0);
        BufferedImage bufferedImage2 = IdealGasResources.getImage("ice.gif");
        this.iceGraphicImage = new PhetImageGraphic(this, bufferedImage2, 290, 445);
        this.addGraphic(this.iceGraphicImage, -6.0);
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, this.stoveImg.getWidth(), this.stoveImg.getHeight());
        PhetShapeGraphic phetShapeGraphic = new PhetShapeGraphic(this, double_, IdealGasConfig.COLOR_SCHEME.background);
        phetShapeGraphic.setLocation(point);
        this.addGraphic(phetShapeGraphic, -5.0);
        ((IdealGasModel)idealGasModule.getModel()).addHeatSourceChangeListener(new FlameIceAdjuster());
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
    }

    public void setStove(int n) {
        int n2 = 445;
        int n3 = n2 - n;
        int n4 = n2 + n;
        this.flamesGraphicImage.setLocation((int)this.flamesGraphicImage.getLocation().getX(), (int)Math.max(Math.min((float)n3, (float)n2), (float)(n2 - this.stoveImg.getHeight())));
        this.iceGraphicImage.setLocation((int)this.iceGraphicImage.getLocation().getX(), (int)Math.max(Math.min((float)n4, (float)n2), (float)(n2 - this.stoveImg.getHeight())));
        this.repaint();
    }

    private class FlameIceAdjuster
    implements IdealGasModel.HeatSourceChangeListener {
        private FlameIceAdjuster() {
        }

        public void heatSourceChanged(IdealGasModel.HeatSourceChangeEvent heatSourceChangeEvent) {
            BaseIdealGasApparatusPanel.this.setStove((int)heatSourceChangeEvent.getHeatSource());
        }
    }
}

