/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.hydrogenatom.view.atom;

import edu.colorado.phet.common.phetcommon.view.graphics.RoundGradientPaint;
import edu.colorado.phet.common.piccolophet.nodes.SphericalNode;
import edu.colorado.phet.hydrogenatom.model.BilliardBallModel;
import edu.colorado.phet.hydrogenatom.view.HAModelViewTransform;
import edu.colorado.phet.hydrogenatom.view.atom.AbstractHydrogenAtomNode;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.Observable;
import java.util.Observer;

public class BilliardBallNode
extends AbstractHydrogenAtomNode
implements Observer {
    private static final Color COLOR = new Color(196, 78, 14);
    private static final Color HILITE_COLOR = new Color(255, 141, 21);
    private BilliardBallModel _atom;

    public BilliardBallNode(BilliardBallModel billiardBallModel) {
        this._atom = billiardBallModel;
        this._atom.addObserver(this);
        double d = HAModelViewTransform.transform(this._atom.getRadius());
        double d2 = 2.0 * d;
        RoundGradientPaint roundGradientPaint = new RoundGradientPaint(0.0, d2 / 6.0, HILITE_COLOR, new Point2D.Double(d2 / 4.0, d2 / 4.0), COLOR);
        SphericalNode sphericalNode = new SphericalNode(d2, roundGradientPaint, true);
        this.addChild(sphericalNode);
        this.setOffset(HAModelViewTransform.transform(this._atom.getPositionRef()));
    }

    public void update(Observable observable, Object object) {
    }
}

