/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.hydrogenatom.view;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.hydrogenatom.model.AlphaParticle;
import edu.colorado.phet.hydrogenatom.model.Model;
import edu.colorado.phet.hydrogenatom.view.HAModelViewTransform;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;

public class TracesNode
extends PhetPNode
implements Model.ModelListener,
Observer {
    private static final Color TRACE_COLOR = Color.LIGHT_GRAY;
    private static final Stroke TRACE_STROKE = new BasicStroke(1.0f);
    private Model _model;
    private HashMap<AlphaParticle, GeneralPath> _pathMap;
    private boolean _enabled;

    public TracesNode(Model model) {
        this.setPickable(false);
        this.setChildrenPickable(false);
        this._model = model;
        this._pathMap = new HashMap();
        this._enabled = false;
    }

    public void setEnabled(boolean bl) {
        this._enabled = bl;
        if (this._enabled) {
            this._model.addModelListener(this);
        } else {
            this._model.removeModelListener(this);
            this.clear();
        }
        this.setVisible(bl);
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public void clear() {
        Set<AlphaParticle> set = this._pathMap.keySet();
        if (set != null) {
            for (AlphaParticle alphaParticle : set) {
                alphaParticle.deleteObserver(this);
            }
            this._pathMap.clear();
            this.repaint();
        }
    }

    protected void paint(PPaintContext pPaintContext) {
        super.paint(pPaintContext);
        Collection<GeneralPath> collection = this._pathMap.values();
        if (collection != null && collection.size() != 0) {
            Graphics2D graphics2D = pPaintContext.getGraphics();
            Color color = graphics2D.getColor();
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setColor(TRACE_COLOR);
            graphics2D.setStroke(TRACE_STROKE);
            for (GeneralPath generalPath : collection) {
                graphics2D.draw(generalPath);
            }
            graphics2D.setColor(color);
            graphics2D.setStroke(stroke);
        }
    }

    public void modelElementAdded(ModelElement modelElement) {
        if (modelElement instanceof AlphaParticle) {
            AlphaParticle alphaParticle = (AlphaParticle)modelElement;
            alphaParticle.addObserver(this);
            Point2D point2D = HAModelViewTransform.transform(alphaParticle.getPositionRef());
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo((float)point2D.getX(), (float)point2D.getY());
            this._pathMap.put(alphaParticle, generalPath);
            this.repaint();
        }
    }

    public void modelElementRemoved(ModelElement modelElement) {
        if (modelElement instanceof AlphaParticle) {
            AlphaParticle alphaParticle = (AlphaParticle)modelElement;
            alphaParticle.deleteObserver(this);
            this._pathMap.remove(alphaParticle);
            this.repaint();
        }
    }

    public void update(Observable observable, Object object) {
        AlphaParticle alphaParticle;
        GeneralPath generalPath;
        if (observable instanceof AlphaParticle && object == "position" && (generalPath = this._pathMap.get(alphaParticle = (AlphaParticle)observable)) != null) {
            Point2D point2D = HAModelViewTransform.transform(alphaParticle.getPositionRef());
            generalPath.lineTo((float)point2D.getX(), (float)point2D.getY());
        }
    }
}

