/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.hydrogenatom.model;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.view.util.VisibleColor;
import edu.colorado.phet.hydrogenatom.HAConstants;
import edu.colorado.phet.hydrogenatom.enums.GunMode;
import edu.colorado.phet.hydrogenatom.enums.LightType;
import edu.colorado.phet.hydrogenatom.model.AlphaParticle;
import edu.colorado.phet.hydrogenatom.model.BohrModel;
import edu.colorado.phet.hydrogenatom.model.FixedObject;
import edu.colorado.phet.hydrogenatom.model.Photon;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Random;

public class Gun
extends FixedObject
implements ModelElement {
    private boolean _enabled;
    private GunMode _mode;
    private double _nozzleWidth;
    private LightType _lightType;
    private double _lightIntensity;
    private double _wavelength;
    private double _minWavelength;
    private double _maxWavelength;
    private double _alphaParticlesIntensity;
    private int _maxParticles;
    private double _dtPerGunFired;
    private double _dtSinceGunFired;
    private double[] _transitionWavelengths;
    private Random _randomWavelengthType;
    private Random _randomTransitionWavelength;
    private Random _randomVisibleWavelength;
    private Random _randomPosition;
    private Random _randomCenterFire;
    private ArrayList<GunListener> _listeners;
    private AffineTransform _transform;

    public Gun(Point2D point2D, double d, double d2, double d3, double d4) {
        super(point2D, d);
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("invalid nozzleWidth: " + d2);
        }
        this._enabled = false;
        this._mode = GunMode.PHOTONS;
        this._nozzleWidth = d2;
        this._lightType = LightType.MONOCHROMATIC;
        this._lightIntensity = 0.0;
        this._wavelength = 380.0;
        this._minWavelength = d3;
        this._maxWavelength = d4;
        this._alphaParticlesIntensity = 0.0;
        this._randomWavelengthType = new Random();
        this._randomTransitionWavelength = new Random();
        this._randomVisibleWavelength = new Random();
        this._randomPosition = new Random();
        this._randomCenterFire = new Random();
        this._dtSinceGunFired = 0.0;
        this.setMaxParticles(20);
        this._listeners = new ArrayList();
        this._transform = new AffineTransform();
        this._transitionWavelengths = BohrModel.getTransitionWavelengths(this._minWavelength, 380.0);
    }

    public void setEnabled(boolean bl) {
        if (this._enabled != bl) {
            this._enabled = bl;
            this.notifyObservers("enabled");
        }
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public void setMode(GunMode gunMode) {
        if (gunMode != this._mode) {
            this._mode = gunMode;
            this.notifyObservers("mode");
        }
    }

    public double getNozzleWidth() {
        return this._nozzleWidth;
    }

    public void setLightType(LightType lightType) {
        if (lightType != LightType.WHITE && lightType != LightType.MONOCHROMATIC) {
            throw new IllegalArgumentException("invalid lightType: " + (Object)((Object)lightType));
        }
        if (lightType != this._lightType) {
            this._lightType = lightType;
            this.notifyObservers("lightType");
        }
    }

    public void setLightIntensity(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("invalid lightIntensity: " + d);
        }
        if (d != this._lightIntensity) {
            this._lightIntensity = d;
            this.notifyObservers("lightIntensity");
        }
    }

    public double getLightIntensity() {
        return this._lightIntensity;
    }

    public void setWavelength(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("invalid wavelength: " + d);
        }
        if (d != this._wavelength) {
            this._wavelength = d;
            this.notifyObservers("waveLength");
        }
    }

    public double getWavelength() {
        return this._wavelength;
    }

    public double getMinWavelength() {
        return this._minWavelength;
    }

    public double getMaxWavelength() {
        return this._maxWavelength;
    }

    public void setAlphaParticlesIntensity(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("invalid alphaParticlesIntensity: " + d);
        }
        if (d != this._alphaParticlesIntensity) {
            this._alphaParticlesIntensity = d;
            this.notifyObservers("alphaParticlesIntensity");
        }
    }

    public double getAlphaParticlesIntensity() {
        return this._alphaParticlesIntensity;
    }

    public void setMaxParticles(int n) {
        this._maxParticles = n;
        this._dtPerGunFired = (double)HAConstants.ANIMATION_BOX_SIZE.height / 5.0 / (double)n;
    }

    public int getMaxParticles() {
        return this._maxParticles;
    }

    public boolean isPhotonsMode() {
        return this._mode == GunMode.PHOTONS;
    }

    public boolean isAlphaParticlesMode() {
        return this._mode == GunMode.ALPHA_PARTICLES;
    }

    public boolean isWhiteLightType() {
        return this._lightType == LightType.WHITE;
    }

    public boolean isMonochromaticLightType() {
        return this._lightType == LightType.MONOCHROMATIC;
    }

    public Color getWavelengthColor() {
        return VisibleColor.wavelengthToColor(this._wavelength, HAConstants.UV_COLOR, HAConstants.IR_COLOR);
    }

    public Color getBeamColor() {
        Color color = null;
        Color color2 = null;
        if (this._enabled) {
            color2 = this._mode == GunMode.PHOTONS ? (this._lightType == LightType.WHITE ? Color.WHITE : this.getWavelengthColor()) : HAConstants.ALPHA_PARTICLES_COLOR;
            if (color2 != null) {
                double d = this._mode == GunMode.PHOTONS ? this._lightIntensity : this._alphaParticlesIntensity;
                int n = (int)(d * 255.0);
                color = new Color(color2.getRed(), color2.getGreen(), color2.getBlue(), n);
            }
        }
        return color;
    }

    private double getRandomWavelength() {
        double d = 0.0;
        if (this._lightType == LightType.MONOCHROMATIC) {
            d = this._wavelength;
        } else if (this._randomWavelengthType.nextDouble() < 0.4) {
            int n = (int)(this._randomTransitionWavelength.nextDouble() * (double)this._transitionWavelengths.length);
            d = this._transitionWavelengths[n];
        } else {
            d = this._randomVisibleWavelength.nextDouble() * 400.0 + 380.0;
        }
        assert (d >= this._minWavelength && d <= this._maxWavelength);
        return d;
    }

    private Point2D getRandomNozzlePoint() {
        double d = 1.0;
        double d2 = 0.0;
        if (this._randomCenterFire.nextDouble() > 0.1) {
            d2 = this._randomPosition.nextDouble() * this._nozzleWidth - this._nozzleWidth / 2.0;
        }
        Point2D.Double double_ = new Point2D.Double(d, d2);
        this._transform.setToIdentity();
        this._transform.rotate(this.getOrientation());
        this._transform.transform(double_, double_);
        ((Point2D)double_).setLocation(((Point2D)double_).getX() + this.getX(), ((Point2D)double_).getY() + this.getY());
        return double_;
    }

    public void stepInTime(double d) {
        if (this._enabled) {
            if (this._mode == GunMode.PHOTONS && this._lightIntensity > 0.0) {
                this.firePhoton(d);
            } else if (this._mode == GunMode.ALPHA_PARTICLES && this._alphaParticlesIntensity > 0.0) {
                this.fireAlphaParticle(d);
            }
        }
    }

    public void fireOnePhotonFromCenter(double d) {
        Point2D.Double double_ = new Point2D.Double(1.0, 0.0);
        this._transform.setToIdentity();
        this._transform.rotate(this.getOrientation());
        this._transform.transform(double_, double_);
        ((Point2D)double_).setLocation(((Point2D)double_).getX() + this.getX(), ((Point2D)double_).getY() + this.getY());
        double d2 = this.getOrientation();
        double d3 = 5.0;
        this.firePhotonFired(new Photon(d, double_, d2, d3));
    }

    private void firePhoton(double d) {
        this._dtSinceGunFired += this._lightIntensity * d;
        if (this._dtSinceGunFired >= this._dtPerGunFired) {
            this._dtSinceGunFired %= this._dtPerGunFired;
            Point2D point2D = this.getRandomNozzlePoint();
            double d2 = this.getOrientation();
            double d3 = 5.0;
            double d4 = this.getRandomWavelength();
            this.firePhotonFired(new Photon(d4, point2D, d2, d3));
        }
    }

    private void fireAlphaParticle(double d) {
        this._dtSinceGunFired += this._alphaParticlesIntensity * d;
        if (this._dtSinceGunFired >= this._dtPerGunFired) {
            this._dtSinceGunFired %= this._dtPerGunFired;
            Point2D point2D = this.getRandomNozzlePoint();
            double d2 = this.getOrientation();
            double d3 = 5.0;
            this.fireAlphaParticleFired(new AlphaParticle(point2D, d2, d3));
        }
    }

    public void addGunFiredListener(GunListener gunListener) {
        this._listeners.add(gunListener);
    }

    private void firePhotonFired(Photon photon) {
        for (GunListener gunListener : new ArrayList<GunListener>(this._listeners)) {
            gunListener.photonFired(photon);
        }
    }

    private void fireAlphaParticleFired(AlphaParticle alphaParticle) {
        for (GunListener gunListener : new ArrayList<GunListener>(this._listeners)) {
            gunListener.alphaParticleFired(alphaParticle);
        }
    }

    public static interface GunListener {
        public void photonFired(Photon var1);

        public void alphaParticleFired(AlphaParticle var1);
    }
}

