/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.hydrogenatom.model;

import edu.colorado.phet.hydrogenatom.model.AbstractHydrogenAtom;
import edu.colorado.phet.hydrogenatom.model.AlphaParticle;
import edu.colorado.phet.hydrogenatom.model.Photon;
import edu.colorado.phet.hydrogenatom.util.RandomUtils;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;

public class BilliardBallModel
extends AbstractHydrogenAtom {
    private static final double MIN_DEFLECTION_ANGLE = Math.toRadians(120.0);
    private static final double MAX_DEFLECTION_ANGLE = Math.toRadians(170.0);
    private double _radius;
    private Shape _shape;

    public BilliardBallModel(Point2D point2D) {
        this(point2D, 30.0);
    }

    public BilliardBallModel(Point2D point2D, double d) {
        super(point2D, 0.0);
        this._radius = d;
        this.updateShape();
    }

    public double getRadius() {
        return this._radius;
    }

    private void updateShape() {
        this._shape = new Ellipse2D.Double(this.getX() - this._radius, this.getY() - this._radius, 2.0 * this._radius, 2.0 * this._radius);
    }

    public void movePhoton(Photon photon, double d) {
        Point2D point2D = photon.getPositionRef();
        if (!photon.isCollided() && this._shape.contains(point2D)) {
            int n = point2D.getX() > this.getX() ? 1 : -1;
            double d2 = (double)n * RandomUtils.nextDouble(MIN_DEFLECTION_ANGLE, MAX_DEFLECTION_ANGLE);
            double d3 = photon.getOrientation() + d2;
            photon.setOrientation(d3);
            photon.setCollided(true);
        }
        super.movePhoton(photon, d);
    }

    public void moveAlphaParticle(AlphaParticle alphaParticle, double d) {
        Point2D point2D = alphaParticle.getPositionRef();
        if (this._shape.contains(point2D)) {
            int n = point2D.getX() > this.getX() ? 1 : -1;
            double d2 = (double)n * RandomUtils.nextDouble(MIN_DEFLECTION_ANGLE, MAX_DEFLECTION_ANGLE);
            double d3 = alphaParticle.getOrientation() + d2;
            alphaParticle.setOrientation(d3);
        }
        super.moveAlphaParticle(alphaParticle, d);
    }
}

