/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.hydrogenatom.model;

import edu.colorado.phet.common.phetcommon.math.PolynomialTerm;
import java.util.ArrayList;

public class AssociatedLegendrePolynomials {
    public static double solve(int n, int n2, double d) {
        Object object;
        int n3;
        if (n > 6) {
            throw new IllegalArgumentException("unstable for l > 6");
        }
        if (n < 0) {
            throw new IllegalArgumentException("l out of bounds: " + n);
        }
        if (n2 < 0 || n2 > n) {
            throw new IllegalArgumentException("m out of bounds: " + n2);
        }
        if (Math.abs(d) > 1.0) {
            throw new IllegalArgumentException("x out of bounds: " + d);
        }
        ArrayList<PolynomialTerm> arrayList = new ArrayList<PolynomialTerm>();
        arrayList.add(new PolynomialTerm(0, 1));
        for (n3 = 0; n3 < n; ++n3) {
            object = new ArrayList();
            for (int i = 0; i < arrayList.size(); ++i) {
                PolynomialTerm polynomialTerm = (PolynomialTerm)arrayList.get(i);
                ((ArrayList)object).add(new PolynomialTerm(polynomialTerm.getPower() + 2, polynomialTerm.getCoeff()));
                ((ArrayList)object).add(new PolynomialTerm(polynomialTerm.getPower(), polynomialTerm.getCoeff() * -1));
            }
            arrayList = object;
        }
        for (n3 = 0; n3 < arrayList.size(); ++n3) {
            object = (PolynomialTerm)arrayList.get(n3);
            arrayList.set(n3, ((PolynomialTerm)object).derive(n + n2));
        }
        double d2 = Math.pow(-1.0, n2) / (Math.pow(2.0, n) * AssociatedLegendrePolynomials.fact(n)) * Math.pow(1.0 - d * d, (double)n2 / 2.0) * AssociatedLegendrePolynomials.eval(arrayList, d);
        return d2;
    }

    private static double eval(ArrayList arrayList, double d) {
        double d2 = 0.0;
        for (int i = 0; i < arrayList.size(); ++i) {
            PolynomialTerm polynomialTerm = (PolynomialTerm)arrayList.get(i);
            d2 += polynomialTerm.eval(d);
        }
        return d2;
    }

    private static double fact(int n) {
        return n == 0 || n == 1 ? 1.0 : (double)n * AssociatedLegendrePolynomials.fact(n - 1);
    }
}

