/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.hydrogenatom.control;

import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.util.PhotonImageFactory;
import edu.colorado.phet.hydrogenatom.HAResources;
import edu.colorado.phet.hydrogenatom.control.RadioButtonWithIcon;
import edu.colorado.phet.hydrogenatom.view.particle.AlphaParticleNode;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class GunTypeControl
extends PhetPNode {
    private static final Color PANEL_BACKGROUND = new Color(30, 30, 30);
    private static final Border PANEL_BORDER = new SoftBevelBorder(1, Color.GRAY, Color.BLACK);
    private JRadioButton _photonsButton;
    private JRadioButton _alphaParticlesButton;
    private EventListenerList _listenerList = new EventListenerList();

    public GunTypeControl(Font font) {
        Image image = PhotonImageFactory.createPhotonImage(600.0, 30.0);
        ImageIcon imageIcon = new ImageIcon(image);
        Image image2 = AlphaParticleNode.createImage();
        ImageIcon imageIcon2 = new ImageIcon(image2);
        RadioButtonWithIcon radioButtonWithIcon = new RadioButtonWithIcon(HAResources.getString("button.photons"), imageIcon);
        this._photonsButton = radioButtonWithIcon.getRadioButton();
        this._photonsButton.setHorizontalTextPosition(4);
        RadioButtonWithIcon radioButtonWithIcon2 = new RadioButtonWithIcon(HAResources.getString("button.alphaParticles"), imageIcon2);
        this._alphaParticlesButton = radioButtonWithIcon2.getRadioButton();
        this._alphaParticlesButton.setHorizontalTextPosition(4);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._photonsButton);
        buttonGroup.add(this._alphaParticlesButton);
        JPanel jPanel = new JPanel();
        jPanel.setBackground(PANEL_BACKGROUND);
        jPanel.setBorder(PANEL_BORDER);
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(jPanel);
        easyGridBagLayout.setInsets(new Insets(0, 0, 0, 20));
        jPanel.setLayout(easyGridBagLayout);
        easyGridBagLayout.setAnchor(17);
        int n = 0;
        int n2 = 0;
        easyGridBagLayout.addComponent(radioButtonWithIcon, n, n2++);
        easyGridBagLayout.addComponent(radioButtonWithIcon2, n, n2);
        PSwing pSwing = new PSwing(jPanel);
        this.addChild(pSwing);
        this._photonsButton.setFont(font);
        this._alphaParticlesButton.setFont(font);
        this._photonsButton.setOpaque(false);
        this._alphaParticlesButton.setOpaque(false);
        final GunTypeControl gunTypeControl = this;
        this._photonsButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (GunTypeControl.this._photonsButton.isSelected()) {
                    GunTypeControl.this.fireChangeEvent(new ChangeEvent(gunTypeControl));
                }
            }
        });
        this._alphaParticlesButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (GunTypeControl.this._alphaParticlesButton.isSelected()) {
                    GunTypeControl.this.fireChangeEvent(new ChangeEvent(gunTypeControl));
                }
            }
        });
        this.setPhotonsSelected(true);
    }

    public void setPhotonsSelected(boolean bl) {
        this._photonsButton.setSelected(bl);
    }

    public boolean isPhotonsSelected() {
        return this._photonsButton.isSelected();
    }

    public void setLabelsForeground(Color color) {
        this._photonsButton.setForeground(color);
        this._alphaParticlesButton.setForeground(color);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this._listenerList.add(ChangeListener.class, changeListener);
    }

    private void fireChangeEvent(ChangeEvent changeEvent) {
        Object[] objectArray = this._listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
        }
    }
}

