/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.hydrogenatom;

import edu.colorado.phet.common.phetcommon.application.ApplicationConstructor;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationLauncher;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import edu.colorado.phet.common.phetcommon.view.menu.HelpMenu;
import edu.colorado.phet.common.piccolophet.PiccoloPhetApplication;
import edu.colorado.phet.hydrogenatom.HAResources;
import edu.colorado.phet.hydrogenatom.dialog.TransitionsDialog;
import edu.colorado.phet.hydrogenatom.menu.DeveloperControlsMenuItem;
import edu.colorado.phet.hydrogenatom.menu.HAOptionsMenu;
import edu.colorado.phet.hydrogenatom.module.HAModule;
import edu.colorado.phet.hydrogenatom.view.LegendPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class HydrogenAtomApplication
extends PiccoloPhetApplication {
    private JDialog _legendDialog;
    private JDialog _transitionsDialog;
    private HAModule _module;

    public HydrogenAtomApplication(PhetApplicationConfig phetApplicationConfig) {
        super(phetApplicationConfig);
        this.initModules();
        this.initMenubar(phetApplicationConfig.getCommandLineArgs());
    }

    private void initModules() {
        this._module = new HAModule();
        this.addModule(this._module);
    }

    private void initMenubar(String[] stringArray) {
        assert (this._module != null);
        PhetFrame phetFrame = this.getPhetFrame();
        HAOptionsMenu hAOptionsMenu = new HAOptionsMenu(this._module);
        if (hAOptionsMenu.getMenuComponentCount() > 0) {
            phetFrame.addMenu(hAOptionsMenu);
        }
        JMenu jMenu = this.getPhetFrame().getDeveloperMenu();
        jMenu.add(new DeveloperControlsMenuItem(this._module));
        HelpMenu helpMenu = phetFrame.getHelpMenu();
        JMenuItem jMenuItem = new JMenuItem(HAResources.getString("menu.help.legend"));
        jMenuItem.setMnemonic(HAResources.getChar("menu.help.legend.mnemonic", 'L'));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HydrogenAtomApplication.this.handleLegendDialog();
            }
        });
        helpMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem(HAResources.getString("menu.help.transitions"));
        jMenuItem2.setMnemonic(HAResources.getChar("menu.help.transitions.mnemonic", 'T'));
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HydrogenAtomApplication.this.handleTransitionsDialog();
            }
        });
        helpMenu.add(jMenuItem2);
    }

    private void handleLegendDialog() {
        if (this._legendDialog != null) {
            this._legendDialog.toFront();
        } else {
            PhetFrame phetFrame = this.getPhetFrame();
            this._legendDialog = new LegendPanel.LegendDialog(phetFrame);
            this._legendDialog.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    HydrogenAtomApplication.this._legendDialog = null;
                }

                public void windowClosed(WindowEvent windowEvent) {
                    HydrogenAtomApplication.this._legendDialog = null;
                }
            });
            this._legendDialog.setVisible(true);
        }
    }

    private void handleTransitionsDialog() {
        if (this._transitionsDialog != null) {
            this._transitionsDialog.toFront();
        } else {
            PhetFrame phetFrame = this.getPhetFrame();
            this._transitionsDialog = new TransitionsDialog(phetFrame);
            this._transitionsDialog.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    HydrogenAtomApplication.this._transitionsDialog = null;
                }

                public void windowClosed(WindowEvent windowEvent) {
                    HydrogenAtomApplication.this._transitionsDialog = null;
                }
            });
            this._transitionsDialog.setVisible(true);
        }
    }

    public static void main(String[] stringArray) {
        ApplicationConstructor applicationConstructor = new ApplicationConstructor(){

            public PhetApplication getApplication(PhetApplicationConfig phetApplicationConfig) {
                return new HydrogenAtomApplication(phetApplicationConfig);
            }
        };
        PhetApplicationConfig phetApplicationConfig = new PhetApplicationConfig(stringArray, "hydrogen-atom");
        new PhetApplicationLauncher().launchSim(phetApplicationConfig, applicationConstructor);
    }
}

