/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.greenhouse.view;

import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.photonabsorption.PhotonAbsorptionResources;
import edu.colorado.phet.greenhouse.GreenhouseResources;
import edu.colorado.phet.greenhouse.common.graphics.CompositeGraphic;
import edu.colorado.phet.greenhouse.common.graphics.ImageGraphic;
import edu.colorado.phet.greenhouse.model.Photon;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;

public class PhotonGraphic
extends CompositeGraphic
implements Observer {
    private static BufferedImage baseImage;
    private static HashMap colorLUT;
    private static BufferedImage redImage;
    private static BufferedImage yellowImage;
    Point2D.Double position = new Point2D.Double();
    private Photon photon;
    private ImageGraphic photonImage;
    private boolean isVisible;
    private double directionOfTravel = Double.POSITIVE_INFINITY;
    private static boolean scaleChanged;
    private Point2D drawLocation = new Point2D.Double();

    public PhotonGraphic(Photon photon) {
        this.photon = photon;
        photon.addObserver(this);
        this.isVisible = true;
        this.update();
    }

    public void update() {
        double d = Math.atan2(-this.photon.getVelocity().getY(), this.photon.getVelocity().getX());
        if (d != this.directionOfTravel || scaleChanged) {
            scaleChanged = false;
            this.directionOfTravel = d;
            if (this.photonImage != null) {
                this.removeGraphic(this.photonImage);
            }
            this.photonImage = new ImageGraphic(this.photon.getWavelength() > 6.0E-7 ? redImage : yellowImage, this.position){

                public void paint(Graphics2D graphics2D) {
                    AffineTransform affineTransform = new AffineTransform(graphics2D.getTransform());
                    super.paint(graphics2D);
                    affineTransform.concatenate(new AffineTransform(this.getImageTx()));
                    try {
                        PhotonGraphic.this.drawLocation.setLocation(affineTransform.transform(new Point2D.Double(PhotonGraphic.this.getImage().getWidth(null) / 2, PhotonGraphic.this.getImage().getHeight(null) / 2), null));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            };
            this.addGraphic(this.photonImage, 0.0);
        }
        double d2 = 0.0;
        if (this.photon.getVelocity().getY() > 0.0) {
            d2 = 1.0;
        }
        double d3 = 0.03;
        this.position.setLocation(this.photon.getLocation().getX() - (double)this.photonImage.getBufferedImage().getWidth() * d3 * 0.5, this.photon.getLocation().getY() - d2 * (double)this.photonImage.getBufferedImage().getHeight() * d3);
    }

    public void update(Observable observable, Object object) {
        this.update();
    }

    public void setVisible(boolean bl) {
        this.isVisible = bl;
    }

    public Image getImage() {
        return this.photonImage.getBufferedImage();
    }

    static {
        colorLUT = new HashMap();
        baseImage = GreenhouseResources.getImage("photon-comet.png");
        double d = 0.5599999999999999;
        redImage = BufferedImageUtils.rescaleFractional(PhotonAbsorptionResources.getImage("photon-660.png"), d, d);
        yellowImage = BufferedImageUtils.rescaleFractional(PhotonAbsorptionResources.getImage("thin2.png"), d, d);
        AffineTransform affineTransform = AffineTransform.getScaleInstance(0.4, 0.4);
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 2);
        baseImage = affineTransformOp.filter(baseImage, null);
        colorLUT.put(new Double(4.0E-7), new Color(255, 255, 120));
        colorLUT.put(new Double(8.5E-7), Color.red);
        colorLUT.put(new Double(1.0), Color.green);
        scaleChanged = false;
    }
}

