/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.greenhouse.model;

import edu.colorado.phet.greenhouse.GreenhouseConfig;
import edu.colorado.phet.greenhouse.filter.BandpassFilter;
import edu.colorado.phet.greenhouse.model.Annulus;
import edu.colorado.phet.greenhouse.model.Earth;
import edu.colorado.phet.greenhouse.model.Photon;
import edu.colorado.phet.greenhouse.model.PhotonAbsorber;
import edu.colorado.phet.greenhouse.model.PhotonEmitter;
import java.util.ArrayList;
import java.util.HashSet;

public class Atmosphere
extends Annulus
implements PhotonAbsorber,
PhotonEmitter {
    private Annulus troposphere;
    private double greenhouseGasConcentration = GreenhouseConfig.defaultGreenhouseGasConcentration;
    ArrayList listeners = new ArrayList();
    private BandpassFilter greenhouseGasFilter = new BandpassFilter(8.5E-7, 8.5E-7);
    private HashSet photonEmitterListeners = new HashSet();
    private HashSet photonAbsorberListeners = new HashSet();
    private Photon photonToEmit;

    public Atmosphere(Earth earth) {
        super(earth.getLocation(), Earth.radius * 2.0, (Earth.radius + 16.0 + 30.0) * 2.0);
        this.troposphere = new Annulus(earth.getLocation(), Earth.radius * 2.0, (Earth.radius + 16.0) * 2.0);
    }

    public double getGreenhouseGasConcentration() {
        return this.greenhouseGasConcentration;
    }

    public void setGreenhouseGasConcentration(double d) {
        this.greenhouseGasConcentration = d;
    }

    public void interactWithPhoton(Photon photon) {
        if (this.greenhouseGasFilter.passes(photon.getWavelength())) {
            boolean bl;
            double d = this.troposphere.distanceFromInnerDiameter(photon.getLocation());
            double d2 = (16.0 - d) * this.greenhouseGasConcentration;
            boolean bl2 = bl = Math.random() <= d2;
            if (bl) {
                double d3 = 0.7853981633974483;
                double d4 = Math.random() * d3 + 4.71238898038469 - d3 / 2.0;
                double d5 = Math.random() < 0.5 ? 0.0 : Math.PI;
                double d6 = photon.getVelocity().getMagnitude();
                photon.setVelocity(d6 * (double)((float)Math.cos(d4 += d5)), d6 * (double)((float)Math.sin(d4)));
                for (int i = 0; i < this.listeners.size(); ++i) {
                    ScatterEventListener scatterEventListener = (ScatterEventListener)this.listeners.get(i);
                    scatterEventListener.photonScatered(photon);
                }
            }
        }
    }

    public void addScatterEventListener(ScatterEventListener scatterEventListener) {
        this.listeners.add(scatterEventListener);
    }

    public Photon emitPhoton() {
        for (PhotonEmitter.Listener listener : this.photonEmitterListeners) {
            listener.photonEmitted(this.photonToEmit);
        }
        return this.photonToEmit;
    }

    public static interface ScatterEventListener {
        public void photonScatered(Photon var1);
    }
}

