/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.greenhouse;

import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.LinearValueControl;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.event.ChangeListener;

public class ClockDelaySlider
extends VerticalLayoutPanel {
    private LinearValueControl linearSlider;
    private int maxDelay;

    public ClockDelaySlider(int n, int n2, String string, final ConstantDtClock constantDtClock, String string2) {
        this.maxDelay = n;
        double d = 1.0;
        double d2 = (double)n / (double)n2;
        this.linearSlider = new LinearValueControl(d, d2, "", string, "");
        this.linearSlider.setTextFieldVisible(false);
        Hashtable<Double, JLabel> hashtable = new Hashtable<Double, JLabel>();
        hashtable.put(new Double(d), new JLabel(PhetCommonResources.getString("Common.time.slow")));
        hashtable.put(new Double(d2), new JLabel(PhetCommonResources.getString("Common.time.fast")));
        if (string2 != null) {
            JLabel jLabel = new JLabel(string2);
            jLabel.setFont(new PhetFont(2, PhetFont.getDefaultFontSize()));
            hashtable.put(new Double((d + d2) / 2.0), jLabel);
        }
        this.linearSlider.setTickLabels(hashtable);
        constantDtClock.addConstantDtClockListener(new ConstantDtClock.ConstantDtClockAdapter(){

            public void delayChanged(ConstantDtClock.ConstantDtClockEvent constantDtClockEvent) {
                ClockDelaySlider.this.update(constantDtClock);
            }
        });
        this.update(constantDtClock);
        this.add(this.linearSlider);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.linearSlider.addChangeListener(changeListener);
    }

    public void update(ConstantDtClock constantDtClock) {
        this.linearSlider.setValue(this.mapDelayValueToSliderValue(constantDtClock.getDelay()));
    }

    private double mapDelayValueToSliderValue(int n) {
        return (double)this.maxDelay / (double)n;
    }

    public double getValue() {
        return this.linearSlider.getValue();
    }
}

