/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.photonabsorption.model.molecules;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.photonabsorption.model.Molecule;
import edu.colorado.phet.common.photonabsorption.model.PhotonAbsorptionStrategy;
import edu.colorado.phet.common.photonabsorption.model.atoms.AtomicBond;
import edu.colorado.phet.common.photonabsorption.model.atoms.OxygenAtom;
import edu.colorado.phet.common.photonabsorption.model.molecules.O;
import edu.colorado.phet.common.photonabsorption.model.molecules.O2;
import java.awt.geom.Point2D;
import java.util.Random;

public class O3
extends Molecule {
    private static final double INITIAL_MOLECULE_HEIGHT = 180.0 * Math.cos(1.0471975511965976);
    private static final double INITIAL_MOLECULE_WIDTH = 360.0 * Math.sin(1.0471975511965976);
    private static final double INITIAL_CENTER_OXYGEN_VERTICAL_OFFSET = 0.6666666666666666 * INITIAL_MOLECULE_HEIGHT;
    private static final double INITIAL_OXYGEN_VERTICAL_OFFSET = -INITIAL_CENTER_OXYGEN_VERTICAL_OFFSET / 2.0;
    private static final double INITIAL_OXYGEN_HORIZONTAL_OFFSET = INITIAL_MOLECULE_WIDTH / 2.0;
    private final OxygenAtom centerOxygenAtom = new OxygenAtom();
    private final OxygenAtom leftOxygenAtom = new OxygenAtom();
    private final OxygenAtom rightOxygenAtom = new OxygenAtom();
    private final AtomicBond leftOxygenOxygenBond;
    private final AtomicBond rightOxygenOxygenBond;
    private static final Random RAND = new Random();
    private final boolean doubleBondOnRight = RAND.nextBoolean();

    public O3(Point2D point2D) {
        if (this.doubleBondOnRight) {
            this.leftOxygenOxygenBond = new AtomicBond(this.centerOxygenAtom, this.leftOxygenAtom, 1);
            this.rightOxygenOxygenBond = new AtomicBond(this.centerOxygenAtom, this.rightOxygenAtom, 2);
        } else {
            this.leftOxygenOxygenBond = new AtomicBond(this.centerOxygenAtom, this.leftOxygenAtom, 2);
            this.rightOxygenOxygenBond = new AtomicBond(this.centerOxygenAtom, this.rightOxygenAtom, 1);
        }
        this.addAtom(this.centerOxygenAtom);
        this.addAtom(this.leftOxygenAtom);
        this.addAtom(this.rightOxygenAtom);
        this.addAtomicBond(this.leftOxygenOxygenBond);
        this.addAtomicBond(this.rightOxygenOxygenBond);
        this.setPhotonAbsorptionStrategy(20.0, new PhotonAbsorptionStrategy.RotationStrategy(this));
        this.setPhotonAbsorptionStrategy(8.5E-7, new PhotonAbsorptionStrategy.VibrationStrategy(this));
        this.setPhotonAbsorptionStrategy(1.0E-7, new PhotonAbsorptionStrategy.BreakApartStrategy(this));
        this.initializeAtomOffsets();
        this.setCenterOfGravityPos(point2D);
    }

    public O3() {
        this(new Point2D.Double(0.0, 0.0));
    }

    protected void initializeAtomOffsets() {
        this.addInitialAtomCogOffset(this.centerOxygenAtom, new Vector2D(0.0, INITIAL_CENTER_OXYGEN_VERTICAL_OFFSET));
        this.addInitialAtomCogOffset(this.leftOxygenAtom, new Vector2D(-INITIAL_OXYGEN_HORIZONTAL_OFFSET, INITIAL_OXYGEN_VERTICAL_OFFSET));
        this.addInitialAtomCogOffset(this.rightOxygenAtom, new Vector2D(INITIAL_OXYGEN_HORIZONTAL_OFFSET, INITIAL_OXYGEN_VERTICAL_OFFSET));
        this.updateAtomPositions();
    }

    public void setVibration(double d) {
        super.setVibration(d);
        double d2 = Math.sin(d);
        double d3 = 30.0;
        double d4 = 15.0;
        this.getVibrationAtomOffset(this.centerOxygenAtom).setComponents(0.0, d2 * d3);
        this.getVibrationAtomOffset(this.rightOxygenAtom).setComponents(-d2 * d4, -d2 * d4);
        this.getVibrationAtomOffset(this.leftOxygenAtom).setComponents(d2 * d4, -d2 * d4);
        this.updateAtomPositions();
    }

    public void breakApart() {
        double d;
        O2 o2 = new O2();
        O o = new O();
        double d2 = 0.5235987755982989;
        if (this.doubleBondOnRight) {
            o2.rotate(-d2);
            o2.setCenterOfGravityPos((this.getInitialAtomCogOffset(this.rightOxygenAtom).getX() + this.getInitialAtomCogOffset(this.centerOxygenAtom).getX()) / 2.0, (this.getInitialAtomCogOffset(this.centerOxygenAtom).getY() + this.getInitialAtomCogOffset(this.rightOxygenAtom).getY()) / 2.0);
            d = 0.7853981633974483 + RAND.nextDouble() * Math.PI / 4.0;
            o.setCenterOfGravityPos(-INITIAL_OXYGEN_HORIZONTAL_OFFSET, INITIAL_OXYGEN_VERTICAL_OFFSET);
        } else {
            o2.rotate(d2);
            d = 1.5707963267948966 + RAND.nextDouble() * Math.PI / 4.0;
            o2.setCenterOfGravityPos((this.getInitialAtomCogOffset(this.leftOxygenAtom).getX() + this.getInitialAtomCogOffset(this.centerOxygenAtom).getX()) / 2.0, (this.getInitialAtomCogOffset(this.leftOxygenAtom).getY() + this.getInitialAtomCogOffset(this.centerOxygenAtom).getY()) / 2.0);
            o.setCenterOfGravityPos(INITIAL_OXYGEN_HORIZONTAL_OFFSET, INITIAL_OXYGEN_VERTICAL_OFFSET);
        }
        o2.setVelocity(0.99 * Math.cos(d), 0.99 * Math.sin(d));
        o.setVelocity(-2.0100000000000002 * Math.cos(d), -2.0100000000000002 * Math.sin(d));
        this.addConstituentMolecule(o2);
        this.addConstituentMolecule(o);
        this.notifyBrokeApart();
    }
}

