/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.gravityandorbits.view;

import edu.colorado.phet.common.phetcommon.util.PhetUtilities;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.event.ButtonEventHandler;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.RoundRectangle2D;
import javax.swing.event.EventListenerList;

public class ZoomButtonNode
extends PhetPNode {
    private static final Color ENABLED_STROKE_COLOR = Color.BLACK;
    private static final Color ENABLED_SHADOW_COLOR = new Color(0.0f, 0.0f, 0.0f, 0.2f);
    private static final Color DISABLED_TEXT_COLOR = new Color(180, 180, 180);
    private static final Color DISABLED_BACKGROUND_COLOR = new Color(210, 210, 210);
    private static final Color DISABLED_STROKE_COLOR = new Color(190, 190, 190);
    private static final Color DISABLED_SHADOW_COLOR = new Color(0, 0, 0, 0);
    private final EventListenerList _listeners;
    private final Color _backgroundColor;
    private final PText _htmlNode;
    private final PPath _zoomButtonNode;
    private final PPath _shadowNode;
    private Color _textColor;
    private boolean _enabled;

    public ZoomButtonNode(PText pText, Color color, Color color2, double d, double d2) {
        this._htmlNode = pText;
        this._htmlNode.setOffset(d / 2.0 - this._htmlNode.getFullBounds().getWidth() / 2.0, d2 / 2.0 - this._htmlNode.getFullBounds().getHeight() / 2.0);
        this._textColor = color;
        this._backgroundColor = color2;
        this._enabled = true;
        this._listeners = new EventListenerList();
        final Paint paint = this.createMouseNotOverGradient();
        final Paint paint2 = this.createMouseOverGradient();
        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(0.0, 0.0, d, d2, 10.0, 10.0);
        this._zoomButtonNode = new PPath(double_);
        this._zoomButtonNode.setPaint(paint);
        this._zoomButtonNode.setStrokePaint(ENABLED_STROKE_COLOR);
        this._zoomButtonNode.addInputEventListener(new CursorHandler());
        this._shadowNode = new PPath(double_);
        this._shadowNode.setPaint(ENABLED_SHADOW_COLOR);
        this._shadowNode.setPickable(false);
        this._shadowNode.setOffset(3.0, 3.0);
        this._shadowNode.setStroke(null);
        this.addChild(this._shadowNode);
        this.addChild(this._zoomButtonNode);
        this._zoomButtonNode.addChild(this._htmlNode);
        ButtonEventHandler buttonEventHandler = new ButtonEventHandler();
        this._zoomButtonNode.addInputEventListener(buttonEventHandler);
        buttonEventHandler.addButtonEventListener(new ButtonEventHandler.ButtonEventListener(){
            private boolean focus = false;

            public void setFocus(boolean bl) {
                this.focus = bl;
                if (ZoomButtonNode.this._enabled) {
                    ZoomButtonNode.this._zoomButtonNode.setPaint(bl ? paint2 : paint);
                }
            }

            public void setArmed(boolean bl) {
                if (bl) {
                    ZoomButtonNode.this._zoomButtonNode.setPaint(ZoomButtonNode.this.createArmedGradient());
                    ZoomButtonNode.this._zoomButtonNode.setOffset(3.0, 3.0);
                } else {
                    ZoomButtonNode.this._zoomButtonNode.setPaint(this.focus ? paint2 : paint);
                    ZoomButtonNode.this._zoomButtonNode.setOffset(0.0, 0.0);
                }
            }

            public void fire() {
                ActionEvent actionEvent = new ActionEvent(this, 0, "BUTTON_FIRED");
                for (ActionListener actionListener : (ActionListener[])ZoomButtonNode.this._listeners.getListeners(ActionListener.class)) {
                    actionListener.actionPerformed(actionEvent);
                }
            }
        });
    }

    private double getHtmlWidth() {
        return this._htmlNode.getFullBoundsReference().getWidth();
    }

    private double getHtmlHeight() {
        return this._htmlNode.getFullBoundsReference().getHeight();
    }

    protected Paint createMouseNotOverGradient() {
        return this.createGradient(ZoomButtonNode.createBrighterColor(this._backgroundColor), this._backgroundColor);
    }

    protected Paint createMouseOverGradient() {
        return this.createGradient(ZoomButtonNode.createBrighterColor(ZoomButtonNode.createBrighterColor(this._backgroundColor)), ZoomButtonNode.createBrighterColor(this._backgroundColor));
    }

    protected Paint createArmedGradient() {
        return this.createGradient(this._backgroundColor, ZoomButtonNode.createBrighterColor(this._backgroundColor));
    }

    private Paint createDisabledGradient() {
        return this.createGradient(ZoomButtonNode.createBrighterColor(DISABLED_BACKGROUND_COLOR), DISABLED_BACKGROUND_COLOR);
    }

    private Paint createGradient(Color color, Color color2) {
        if (PhetUtilities.isMacintosh()) {
            return color2;
        }
        return new GradientPaint((float)this.getHtmlWidth() / 2.0f, 0.0f, color, (float)this.getHtmlWidth() * 0.5f, (float)this.getHtmlHeight(), color2);
    }

    public void addActionListener(ActionListener actionListener) {
        this._listeners.add(ActionListener.class, actionListener);
    }

    private static Color createBrighterColor(Color color) {
        int n = color.getRed() + (int)Math.round((double)(255 - color.getRed()) * 0.5);
        int n2 = color.getGreen() + (int)Math.round((double)(255 - color.getGreen()) * 0.5);
        int n3 = color.getBlue() + (int)Math.round((double)(255 - color.getBlue()) * 0.5);
        int n4 = color.getAlpha();
        return new Color(n, n2, n3, n4);
    }

    public void setEnabled(boolean bl) {
        if (this._enabled != bl) {
            this._enabled = bl;
            if (bl) {
                this._zoomButtonNode.setPaint(this.createMouseNotOverGradient());
                this._zoomButtonNode.setStrokePaint(ENABLED_STROKE_COLOR);
                this._htmlNode.setTextPaint(this._textColor);
                this._shadowNode.setPaint(ENABLED_SHADOW_COLOR);
            } else {
                this._zoomButtonNode.setPaint(this.createDisabledGradient());
                this._zoomButtonNode.setStrokePaint(DISABLED_STROKE_COLOR);
                this._htmlNode.setTextPaint(DISABLED_TEXT_COLOR);
                this._shadowNode.setPaint(DISABLED_SHADOW_COLOR);
            }
            this.setPickable(bl);
            this.setChildrenPickable(bl);
        }
    }
}

