/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.gravityandorbits.view;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.common.phetcommon.model.property.Not;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.RichSimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.piccolophet.nodes.ArrowNode;
import edu.colorado.phet.gravityandorbits.model.Body;
import edu.umd.cs.piccolo.PNode;
import java.awt.Color;
import java.awt.geom.Point2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VectorNode
extends PNode {
    private final Body body;
    private final Property<ModelViewTransform> modelViewTransform;
    private final double scale;
    private Property<ImmutableVector2D> vector;
    private ArrowNode arrowNode;

    public VectorNode(Body body, Property<ModelViewTransform> property, BooleanProperty booleanProperty, Property<ImmutableVector2D> property2, double d, final Color color, final Color color2) {
        this.vector = property2;
        this.body = body;
        this.modelViewTransform = property;
        this.scale = d;
        booleanProperty.and(Not.not(body.getCollidedProperty())).addObserver(new VoidFunction1<Boolean>(){

            @Override
            public void apply(Boolean bl) {
                VectorNode.this.setVisible(bl);
            }
        });
        this.arrowNode = new ArrowNode(new Point2D.Double(), new Point2D.Double(), 15.0, 15.0, 5.0, 0.5, true){
            {
                super(point2D, point2D2, d, d2, d3, d4, bl);
                this.setPaint(color);
                this.setStrokePaint(color2);
            }
        };
        new RichSimpleObserver(){

            public void update() {
                Point2D point2D = VectorNode.this.getTail();
                VectorNode.this.arrowNode.setTipAndTailLocations(VectorNode.this.getTip(point2D), point2D);
            }
        }.observe(property2, body.getPositionProperty(), property);
        this.addChild(this.arrowNode);
        this.arrowNode.setPickable(false);
        this.arrowNode.setChildrenPickable(false);
    }

    private Point2D getTail() {
        return this.modelViewTransform.get().modelToView(((ImmutableVector2D)this.body.getPositionProperty().get()).toPoint2D());
    }

    protected Point2D getTip() {
        return this.getTip(this.getTail());
    }

    private Point2D.Double getTip(Point2D point2D) {
        int n = 10;
        ImmutableVector2D immutableVector2D = new ImmutableVector2D(this.modelViewTransform.get().modelToViewDelta(this.vector.get().getScaledInstance(this.scale).toPoint2D()));
        if (immutableVector2D.getMagnitude() < (double)n && immutableVector2D.getMagnitude() > 1.0E-12) {
            immutableVector2D = immutableVector2D.getInstanceOfMagnitude(n);
        }
        return new Point2D.Double(immutableVector2D.getX() + point2D.getX(), immutableVector2D.getY() + point2D.getY());
    }
}

