/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.gravityandorbits.view;

import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.gravityandorbits.GAOStrings;
import edu.colorado.phet.gravityandorbits.view.BodyNode;
import edu.colorado.phet.gravityandorbits.view.MassReadoutNode;
import java.text.DecimalFormat;
import java.text.MessageFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpaceStationMassReadoutNode
extends MassReadoutNode {
    public SpaceStationMassReadoutNode(BodyNode bodyNode, Property<Boolean> property) {
        super(bodyNode, property);
    }

    @Override
    protected String createText() {
        String string;
        double d = this.bodyNode.getBody().getMass();
        double d2 = d / 369914.0;
        String string2 = GAOStrings.SPACE_STATION_MASS;
        if (d2 > 1.0E18) {
            string = new DecimalFormat("0").format(d2 / 1.0E18);
            string2 = GAOStrings.BILLION_BILLION_SPACE_STATION_MASSES;
        } else {
            string = Math.abs(d2 - 1.0) < 0.01 ? "1" : (d2 < 1.0 ? new DecimalFormat("0.000").format(d2) : new DecimalFormat("0.00").format(d2));
        }
        return MessageFormat.format(GAOStrings.PATTERN_VALUE_UNITS, string, string2);
    }
}

