/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.gravityandorbits.view;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.gravityandorbits.model.Body;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathNode
extends PNode {
    private final PNode pathNode;
    private ArrayList<ImmutableVector2D> points = new ArrayList();

    public PathNode(final Body body, final Property<ModelViewTransform> property, final Property<Boolean> property2, final Color color) {
        final BasicStroke basicStroke = new BasicStroke(3.0f, 1, 1);
        this.pathNode = new PNode(){

            protected void paint(PPaintContext pPaintContext) {
                Graphics2D graphics2D = pPaintContext.getGraphics();
                graphics2D.setPaint(color);
                graphics2D.setStroke(basicStroke);
                int n = Math.min(body.getMaxPathLength() - 25, PathNode.this.points.size());
                int n2 = PathNode.this.points.size() - n;
                GeneralPath generalPath = new GeneralPath();
                if (PathNode.this.points.size() > 0) {
                    generalPath.moveTo((float)((ImmutableVector2D)PathNode.this.points.get(PathNode.this.points.size() - 1)).getX(), (float)((ImmutableVector2D)PathNode.this.points.get(PathNode.this.points.size() - 1)).getY());
                }
                for (int i = PathNode.this.points.size() - 2; i >= n2; --i) {
                    generalPath.lineTo((float)((ImmutableVector2D)PathNode.this.points.get(i)).getX(), (float)((ImmutableVector2D)PathNode.this.points.get(i)).getY());
                }
                graphics2D.draw(generalPath);
                graphics2D.setStroke(new BasicStroke(3.0f, 0, 1));
                Color color2 = color;
                for (int i = n2 - 1; i >= 0; --i) {
                    int n3 = (int)((double)color2.getAlpha() - 10.2);
                    color2 = new Color(color2.getRed(), color2.getGreen(), color2.getBlue(), Math.max(0, n3));
                    graphics2D.setColor(color2);
                    graphics2D.drawLine((int)((ImmutableVector2D)PathNode.this.points.get(i + 1)).getX(), (int)((ImmutableVector2D)PathNode.this.points.get(i + 1)).getY(), (int)((ImmutableVector2D)PathNode.this.points.get(i)).getX(), (int)((ImmutableVector2D)PathNode.this.points.get(i)).getY());
                }
            }
        };
        this.pathNode.setBounds(new Rectangle2D.Double(-10000.0, -10000.0, 20000.0, 20000.0));
        this.addChild(this.pathNode);
        property2.addObserver(new SimpleObserver(){

            public void update() {
                PathNode.this.setVisible((Boolean)property2.get());
                body.clearPath();
                PathNode.this.points.clear();
                PathNode.this.pathNode.repaint();
            }
        });
        Body.PathListener pathListener = new Body.PathListener(){

            public void pointAdded(ImmutableVector2D immutableVector2D) {
                ImmutableVector2D immutableVector2D2 = ((ModelViewTransform)property.get()).modelToView(immutableVector2D);
                PathNode.this.points.add(immutableVector2D2);
                PathNode.this.pathNode.repaint();
            }

            public void pointRemoved() {
                if (PathNode.this.points.size() > 0) {
                    PathNode.this.points.remove(0);
                }
                PathNode.this.pathNode.repaint();
            }

            public void cleared() {
                PathNode.this.points.clear();
                PathNode.this.pathNode.repaint();
            }
        };
        body.addPathListener(pathListener);
        property.addObserver(new SimpleObserver(){

            public void update() {
                body.clearPath();
            }
        });
    }
}

