/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.gravityandorbits.view;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.model.property.ObservableProperty;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.RichSimpleObserver;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.Function1;
import edu.colorado.phet.common.phetcommon.view.PhetColorScheme;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.gravityandorbits.GAOStrings;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.MessageFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeasuringTape
extends PNode {
    public static double METERS_PER_MILE = 6.21371192E-4;

    public MeasuringTape(final ObservableProperty<Boolean> observableProperty, final Property<ImmutableVector2D> property, final Property<ImmutableVector2D> property2, final Property<ModelViewTransform> property3) {
        this.addChild(new PhetPPath(new BasicStroke(3.0f), Color.gray){
            {
                super(stroke, paint);
                this.setPickable(false);
                new RichSimpleObserver(){

                    public void update() {
                        this.setPathTo(new Line2D.Double(((ModelViewTransform)property3.get()).modelToView((ImmutableVector2D)property.get()).toPoint2D(), ((ModelViewTransform)property3.get()).modelToView((ImmutableVector2D)property2.get()).toPoint2D()));
                    }
                }.observe(property, property2, property3);
            }
        });
        try {
            this.addChild(this.createMeasuringTapeBody(property, property2, property3));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.addChild(new CrossHairGraphic(property, property3));
        this.addChild(new CrossHairGraphic(property2, property3));
        this.addChild(this.createTextReadout(property, property2, property3));
        observableProperty.addObserver(new SimpleObserver(){

            public void update() {
                MeasuringTape.this.setVisible((Boolean)observableProperty.get());
            }
        });
    }

    private PText createTextReadout(final Property<ImmutableVector2D> property, final Property<ImmutableVector2D> property2, final Property<ModelViewTransform> property3) {
        return new PText("Hello"){
            {
                super(string);
                this.setFont(new PhetFont(18, true));
                this.setTextPaint(Color.white);
                this.setPickable(false);
                final SimpleObserver simpleObserver = new SimpleObserver(){

                    public void update() {
                        Point2D point2D = ((ModelViewTransform)property3.get()).modelToView(((ImmutableVector2D)property.get()).toPoint2D());
                        this.setOffset(point2D.getX() - this.getFullBounds().getWidth() / 2.0, point2D.getY() + 4.0);
                    }
                };
                property3.addObserver(simpleObserver);
                property.addObserver(simpleObserver);
                SimpleObserver simpleObserver2 = new SimpleObserver(){

                    public void update() {
                        double d = ((ImmutableVector2D)property.get()).getDistance((ImmutableVector2D)property2.get());
                        double d2 = MeasuringTape.metersToMiles(d);
                        double d3 = d2 / 1000.0;
                        String string = new Function1<Double, DecimalFormat>(){

                            @Override
                            public DecimalFormat apply(Double d) {
                                if (d < 0.01) {
                                    return new DecimalFormat("0");
                                }
                                if (d < 10.0) {
                                    return new DecimalFormat("0.0");
                                }
                                return new DecimalFormat("0");
                            }
                        }.apply((Double)d3).format(d3);
                        this.setText(MessageFormat.format(GAOStrings.PATTERN_VALUE_UNITS, string, GAOStrings.THOUSAND_MILES));
                        simpleObserver.update();
                    }
                };
                property.addObserver(simpleObserver2);
                property2.addObserver(simpleObserver2);
            }
        };
    }

    private PImage createMeasuringTapeBody(final Property<ImmutableVector2D> property, final Property<ImmutableVector2D> property2, final Property<ModelViewTransform> property3) throws IOException {
        return new PImage(ImageLoader.loadBufferedImage("piccolo-phet/images/measuringTape.png")){
            {
                super(image);
                SimpleObserver simpleObserver = new SimpleObserver(){

                    public void update() {
                        this.setTransform(new AffineTransform());
                        Point2D.Double double_ = ((ModelViewTransform)property3.get()).modelToView((ImmutableVector2D)property.get()).toPoint2D();
                        this.translate(double_.getX() - this.getFullBounds().getWidth(), double_.getY() - this.getFullBounds().getHeight() + 4.0);
                        ImmutableVector2D immutableVector2D = new ImmutableVector2D(((ImmutableVector2D)property.get()).toPoint2D(), ((ImmutableVector2D)property2.get()).toPoint2D());
                        double d = new ImmutableVector2D(immutableVector2D.getX(), -immutableVector2D.getY()).getAngle();
                        this.rotateAboutPoint(d, this.getFullBounds().getWidth(), this.getFullBounds().getHeight() - 4.0);
                    }
                };
                property.addObserver(simpleObserver);
                property2.addObserver(simpleObserver);
                property3.addObserver(simpleObserver);
                this.addInputEventListener(new CursorHandler());
                this.addInputEventListener(new DragHandler((PNode)this, property3, new Property[]{property, property2}));
            }
        };
    }

    public static double metersToMiles(double d) {
        return d * METERS_PER_MILE;
    }

    public static double milesToMeters(double d) {
        return d / METERS_PER_MILE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CrossHairGraphic
    extends PNode {
        public CrossHairGraphic(final Property<ImmutableVector2D> property, final Property<ModelViewTransform> property2) {
            this.addChild(new PhetPPath((Shape)new Ellipse2D.Double(-4.0, -4.0, 8.0, 8.0), (Paint)new Color(0, 0, 0, 0)));
            this.addChild(new PhetPPath(new Line2D.Double(-4.0, 0.0, 4.0, 0.0), (Stroke)new BasicStroke(2.0f), (Paint)PhetColorScheme.RED_COLORBLIND));
            this.addChild(new PhetPPath(new Line2D.Double(0.0, -4.0, 0.0, 4.0), (Stroke)new BasicStroke(2.0f), (Paint)PhetColorScheme.RED_COLORBLIND));
            SimpleObserver simpleObserver = new SimpleObserver(){

                public void update() {
                    CrossHairGraphic.this.setOffset(((ModelViewTransform)property2.get()).modelToView((ImmutableVector2D)property.get()).toPoint2D());
                }
            };
            property.addObserver(simpleObserver);
            property2.addObserver(simpleObserver);
            this.addInputEventListener(new CursorHandler());
            this.addInputEventListener(new DragHandler((PNode)this, (Property)property2, new Property[]{property}));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DragHandler
    extends PBasicInputEventHandler {
        private final PNode node;
        private final Property<ModelViewTransform> transform;
        private final Property<ImmutableVector2D>[] points;

        private DragHandler(PNode pNode, Property<ModelViewTransform> property, Property<ImmutableVector2D> ... propertyArray) {
            this.node = pNode;
            this.transform = property;
            this.points = propertyArray;
        }

        @Override
        public void mouseDragged(PInputEvent pInputEvent) {
            Dimension2D dimension2D = this.transform.get().viewToModelDelta(pInputEvent.getDeltaRelativeTo(this.node.getParent()));
            for (Property<ImmutableVector2D> property : this.points) {
                property.set(new ImmutableVector2D(property.get().getX() + dimension2D.getWidth(), property.get().getY() + dimension2D.getHeight()));
            }
        }
    }
}

