/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.gravityandorbits.view;

import edu.colorado.phet.common.phetcommon.model.property.And;
import edu.colorado.phet.common.phetcommon.model.property.Not;
import edu.colorado.phet.common.phetcommon.model.property.ObservableProperty;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.gravityandorbits.view.BodyNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MassReadoutNode
extends PNode {
    protected final BodyNode bodyNode;

    public MassReadoutNode(final BodyNode bodyNode, Property<Boolean> property) {
        this.bodyNode = bodyNode;
        this.addChild(new PText(this.createText()){
            {
                super(string);
                this.setPickable(false);
                this.setChildrenPickable(false);
                this.setFont(new PhetFont(18, true));
                this.setTextPaint(Color.white);
                bodyNode.getBody().getMassProperty().addObserver(new SimpleObserver(){

                    public void update() {
                        this.setText(MassReadoutNode.this.createText());
                    }
                });
            }
        });
        final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                PBounds pBounds = bodyNode.getBodyRenderer().getGlobalFullBounds();
                MassReadoutNode.this.globalToLocal(pBounds);
                MassReadoutNode.this.localToParent(pBounds);
                if (bodyNode.getBody().isMassReadoutBelow()) {
                    MassReadoutNode.this.setOffset(pBounds.getCenterX() - MassReadoutNode.this.getFullBounds().getWidth() / 2.0, pBounds.getMaxY());
                } else {
                    MassReadoutNode.this.setOffset(pBounds.getCenterX() - MassReadoutNode.this.getFullBounds().getWidth() / 2.0, pBounds.getMinY() - MassReadoutNode.this.getFullBounds().getHeight());
                }
            }
        };
        bodyNode.addPropertyChangeListener("fullBounds", propertyChangeListener);
        property.addObserver(new SimpleObserver(){

            public void update() {
                propertyChangeListener.propertyChange(null);
            }
        });
        new And(new ObservableProperty[]{property, new Not((ObservableProperty<Boolean>)bodyNode.getBody().getCollidedProperty())}){
            {
                this.addObserver(new SimpleObserver(){

                    public void update() {
                        MassReadoutNode.this.setVisible((Boolean)this.get());
                    }
                });
            }
        };
    }

    protected abstract String createText();
}

