/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.gravityandorbits.view;

import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.model.property.IfElse;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.PhetColorScheme;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.nodes.ButtonNode;
import edu.colorado.phet.common.piccolophet.nodes.ControlPanelNode;
import edu.colorado.phet.common.piccolophet.nodes.ResetAllButtonNode;
import edu.colorado.phet.common.piccolophet.nodes.SimSpeedControlPNode;
import edu.colorado.phet.common.piccolophet.nodes.TextButtonNode;
import edu.colorado.phet.common.piccolophet.nodes.mediabuttons.DefaultIconButton;
import edu.colorado.phet.common.piccolophet.nodes.mediabuttons.FloatingClockControlNode;
import edu.colorado.phet.gravityandorbits.GAOStrings;
import edu.colorado.phet.gravityandorbits.controlpanel.GravityAndOrbitsControlPanel;
import edu.colorado.phet.gravityandorbits.model.Body;
import edu.colorado.phet.gravityandorbits.model.GravityAndOrbitsModel;
import edu.colorado.phet.gravityandorbits.module.GravityAndOrbitsMode;
import edu.colorado.phet.gravityandorbits.module.GravityAndOrbitsModule;
import edu.colorado.phet.gravityandorbits.view.BodyNode;
import edu.colorado.phet.gravityandorbits.view.ExplosionNode;
import edu.colorado.phet.gravityandorbits.view.GrabbableVectorNode;
import edu.colorado.phet.gravityandorbits.view.GridNode;
import edu.colorado.phet.gravityandorbits.view.MeasuringTape;
import edu.colorado.phet.gravityandorbits.view.MultiwayOr;
import edu.colorado.phet.gravityandorbits.view.PathNode;
import edu.colorado.phet.gravityandorbits.view.VectorNode;
import edu.colorado.phet.gravityandorbits.view.ZoomButtonNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GravityAndOrbitsCanvas
extends PhetPCanvas {
    private final PNode rootNode;
    public static final PDimension STAGE_SIZE = new PDimension(1008.0, 679.0);
    public static final Color buttonBackgroundColor = new Color(255, 250, 125);

    public GravityAndOrbitsCanvas(final GravityAndOrbitsModel gravityAndOrbitsModel, final GravityAndOrbitsModule gravityAndOrbitsModule, final GravityAndOrbitsMode gravityAndOrbitsMode, double d) {
        super(new Dimension(1500, 1500));
        PNode pNode;
        this.setWorldTransformStrategy(new PhetPCanvas.CenteredStage(this, STAGE_SIZE));
        gravityAndOrbitsModule.whiteBackgroundProperty.addObserver(new SimpleObserver(){

            public void update() {
                GravityAndOrbitsCanvas.this.setBackground(gravityAndOrbitsModule.whiteBackgroundProperty.get() != false ? Color.white : Color.black);
            }
        });
        this.rootNode = new PNode();
        this.addWorldChild(this.rootNode);
        final Property<ImmutableVector2D> property = new Property<ImmutableVector2D>(new ImmutableVector2D());
        this.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent mouseEvent) {
            }

            public void mouseMoved(MouseEvent mouseEvent) {
                property.set(new ImmutableVector2D(mouseEvent.getPoint().x, mouseEvent.getPoint().y));
            }
        });
        for (Body object32 : gravityAndOrbitsModel.getBodies()) {
            this.addChild(new PathNode(object32, gravityAndOrbitsMode.transform, gravityAndOrbitsModule.showPathProperty, object32.getColor()));
        }
        Color color = PhetColorScheme.GRAVITATIONAL_FORCE;
        Color color2 = Color.darkGray;
        Color color3 = PhetColorScheme.VELOCITY;
        Color color4 = Color.darkGray;
        ArrayList<Property<Boolean>> arrayList = new ArrayList<Property<Boolean>>();
        for (final Body body : gravityAndOrbitsModel.getBodies()) {
            pNode = new BodyNode(body, gravityAndOrbitsMode.transform, property, this, body.getLabelAngle(), gravityAndOrbitsModule.whiteBackgroundProperty);
            this.addChild(pNode);
            arrayList.add(new Property<Boolean>(Boolean.valueOf(false)){
                {
                    super(bl);
                    final SimpleObserver simpleObserver = new SimpleObserver(){

                        public void update() {
                            Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, GravityAndOrbitsCanvas.this.getWidth(), GravityAndOrbitsCanvas.this.getHeight());
                            this.set(!double_.intersects(pNode.getGlobalFullBounds()));
                        }
                    };
                    body.getPositionProperty().addObserver(simpleObserver);
                    GravityAndOrbitsCanvas.this.addHierarchyListener(new HierarchyListener(){

                        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                            simpleObserver.update();
                        }
                    });
                    GravityAndOrbitsCanvas.this.addComponentListener(new ComponentAdapter(){

                        public void componentResized(ComponentEvent componentEvent) {
                            simpleObserver.update();
                        }
                    });
                }
            });
            this.addChild(gravityAndOrbitsMode.massReadoutFactory.apply((BodyNode)pNode, gravityAndOrbitsModule.showMassProperty));
        }
        for (Body body : gravityAndOrbitsModel.getBodies()) {
            this.addChild(new VectorNode(body, gravityAndOrbitsMode.transform, gravityAndOrbitsModule.showGravityForceProperty, body.getForceProperty(), d, color, color2));
        }
        for (Body body : gravityAndOrbitsModel.getBodies()) {
            if (body.fixed) continue;
            this.addChild(new GrabbableVectorNode(body, gravityAndOrbitsMode.transform, gravityAndOrbitsModule.showVelocityProperty, body.getVelocityProperty(), gravityAndOrbitsMode.getVelocityVectorScale(), color3, color4, "V"));
        }
        for (Body body : gravityAndOrbitsModel.getBodies()) {
            this.addChild(new ExplosionNode(body, gravityAndOrbitsMode.transform));
        }
        this.addChild(new GridNode(gravityAndOrbitsMode.transform, gravityAndOrbitsMode.getGridSpacing(), gravityAndOrbitsMode.getGridCenter()){
            {
                super(property, d, double_);
                gravityAndOrbitsModule.showGridProperty.addObserver(new SimpleObserver(){

                    public void update() {
                        this.setVisible(gravityAndOrbitsModule.showGridProperty.get());
                    }
                });
            }
        });
        final ControlPanelNode controlPanelNode = new ControlPanelNode(new PSwing(new GravityAndOrbitsControlPanel(gravityAndOrbitsModule, gravityAndOrbitsModel)), GravityAndOrbitsControlPanel.BACKGROUND, new BasicStroke(3.0f), Color.green, 4){
            {
                this.setOffset(STAGE_SIZE.getWidth() - this.getFullBounds().getWidth(), 2.0);
                this.setScale(0.82);
            }
        };
        this.addChild(controlPanelNode);
        final Color color5 = Color.BLACK;
        pNode = new TextButtonNode(GAOStrings.RESET, GravityAndOrbitsControlPanel.CONTROL_FONT){
            {
                super(string, font);
                this.setForeground(color5);
                this.setBackground(buttonBackgroundColor);
                this.setOffset(controlPanelNode.getFullBounds().getCenterX() - this.getFullBounds().getWidth() / 2.0, controlPanelNode.getFullBounds().getMaxY() + 5.0);
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        gravityAndOrbitsModule.modeProperty.get().resetMode();
                    }
                });
            }
        };
        this.addChild(pNode);
        this.addChild(new ResetAllButtonNode(gravityAndOrbitsModule, this, GravityAndOrbitsControlPanel.CONTROL_FONT.getSize(), color5, buttonBackgroundColor, (ButtonNode)pNode){
            final /* synthetic */ ButtonNode val$resetModeButton;
            {
                this.val$resetModeButton = buttonNode;
                super(resettable, component, n, color, color2);
                this.setFont(GravityAndOrbitsControlPanel.CONTROL_FONT);
                this.setOffset(this.val$resetModeButton.getFullBounds().getCenterX() - this.getFullBounds().getWidth() / 2.0, this.val$resetModeButton.getFullBounds().getMaxY() + 5.0);
                this.setConfirmationEnabled(false);
            }
        });
        final ArrayList<Property<Boolean>> arrayList2 = new ArrayList<Property<Boolean>>();
        for (Body body : gravityAndOrbitsModel.getBodies()) {
            arrayList2.add(body.anyPropertyDifferent());
        }
        this.addChild(new FloatingClockControlNode(gravityAndOrbitsModule.playButtonPressed, gravityAndOrbitsMode.getTimeFormatter(), gravityAndOrbitsModel.getClock(), GAOStrings.CLEAR, new IfElse<Color>(gravityAndOrbitsModule.whiteBackgroundProperty, Color.black, Color.white)){
            {
                super(settableProperty, function1, iClock, string, observableProperty);
                this.setOffset(STAGE_SIZE.getWidth() / 2.0 - this.getFullBounds().getWidth() / 2.0, STAGE_SIZE.getHeight() - this.getFullBounds().getHeight());
                FloatingClockControlNode.FloatingRewindButton floatingRewindButton = new FloatingClockControlNode.FloatingRewindButton(){
                    {
                        this.addListener(new DefaultIconButton.Listener(){

                            public void buttonPressed() {
                                gravityAndOrbitsMode.rewind();
                            }
                        });
                        final MultiwayOr multiwayOr = new MultiwayOr(arrayList2);
                        multiwayOr.addObserver(new SimpleObserver(){

                            public void update() {
                                this.setEnabled((Boolean)multiwayOr.get());
                            }
                        });
                    }
                };
                this.addChild(floatingRewindButton);
                assert (gravityAndOrbitsMode.timeSpeedScaleProperty != null);
                this.addChild(new SimSpeedControlPNode(0.1, gravityAndOrbitsMode.timeSpeedScaleProperty, 2.0, floatingRewindButton.getFullBoundsReference().getMinX(), new IfElse<Color>(gravityAndOrbitsModule.whiteBackgroundProperty, Color.black, Color.white)));
            }
        });
        this.addChild(new MeasuringTape(gravityAndOrbitsModule.measuringTapeVisibleProperty, gravityAndOrbitsMode.measuringTapeStartPoint, gravityAndOrbitsMode.measuringTapeEndPoint, gravityAndOrbitsMode.transform));
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, GravityAndOrbitsCanvas.STAGE_SIZE.width, GravityAndOrbitsCanvas.STAGE_SIZE.height);
        for (Body body : gravityAndOrbitsMode.getModel().getBodies()) {
            body.getBounds().set(gravityAndOrbitsMode.transform.get().viewToModel(double_));
        }
        final MultiwayOr multiwayOr = new MultiwayOr((List<Property<Boolean>>)arrayList);
        this.addChild(new TextButtonNode(GAOStrings.RETURN_OBJECT){
            {
                super(string);
                this.setFont(GravityAndOrbitsControlPanel.CONTROL_FONT);
                this.setBackground(buttonBackgroundColor);
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        gravityAndOrbitsModel.returnBodies();
                        gravityAndOrbitsModule.playButtonPressed.set(false);
                    }
                });
                multiwayOr.addObserver(new SimpleObserver(){

                    public void update() {
                        this.setVisible((Boolean)multiwayOr.get());
                    }
                });
                this.setOffset(100.0, 100.0);
            }
        });
        this.addChild(this.createZoomControls(gravityAndOrbitsMode));
    }

    private PNode createZoomControls(final GravityAndOrbitsMode gravityAndOrbitsMode) {
        return new PNode(){
            {
                final PhetFont phetFont = new PhetFont(20, true);
                PText pText = new PText(GAOStrings.ZOOM_IN){
                    {
                        super(string);
                        this.setFont(phetFont);
                    }
                };
                PText pText2 = new PText(GAOStrings.ZOOM_OUT){
                    {
                        super(string);
                        this.setFont(phetFont);
                    }
                };
                PDimension pDimension = new PDimension(Math.max(pText.getFullBounds().getWidth(), pText2.getFullBounds().getWidth()), Math.max(pText.getFullBounds().getHeight(), pText2.getFullBounds().getHeight()));
                double d = Math.max(pDimension.getWidth(), pDimension.getHeight()) - 7.0;
                ZoomButtonNode zoomButtonNode = new ZoomButtonNode(pText, Color.black, buttonBackgroundColor, d, d){
                    {
                        super(pText, color, color2, d, d2);
                        GravityAndOrbitsCanvas.this.setFont(phetFont);
                        this.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                gravityAndOrbitsMode.zoomLevel.set(Math.min(1.5, gravityAndOrbitsMode.zoomLevel.get() + 0.1));
                            }
                        });
                        gravityAndOrbitsMode.zoomLevel.addObserver(new SimpleObserver(){

                            public void update() {
                                this.setEnabled(gravityAndOrbitsMode.zoomLevel.get() != 1.5);
                            }
                        });
                    }
                };
                ZoomButtonNode zoomButtonNode2 = new ZoomButtonNode(pText2, Color.black, buttonBackgroundColor, d, d){
                    {
                        super(pText, color, color2, d, d2);
                        GravityAndOrbitsCanvas.this.setFont(phetFont);
                        this.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                gravityAndOrbitsMode.zoomLevel.set(Math.max(0.5, gravityAndOrbitsMode.zoomLevel.get() - 0.1));
                            }
                        });
                        gravityAndOrbitsMode.zoomLevel.addObserver(new SimpleObserver(){

                            public void update() {
                                this.setEnabled(gravityAndOrbitsMode.zoomLevel.get() != 0.5);
                            }
                        });
                    }
                };
                PSwing pSwing = new PSwing(new JSlider(1, 0, 100, 50){
                    {
                        this.setBackground(new Color(0, 0, 0, 0));
                        this.setPaintTicks(true);
                        this.setMajorTickSpacing(25);
                        final Function.LinearFunction linearFunction = new Function.LinearFunction(0.0, 100.0, 0.5, 1.5);
                        this.addChangeListener(new ChangeListener(){

                            public void stateChanged(ChangeEvent changeEvent) {
                                gravityAndOrbitsMode.zoomLevel.set(linearFunction.evaluate(this.getValue()));
                            }
                        });
                        gravityAndOrbitsMode.zoomLevel.addObserver(new SimpleObserver(){

                            public void update() {
                                this.setValue((int)linearFunction.createInverse().evaluate(gravityAndOrbitsMode.zoomLevel.get()));
                            }
                        });
                    }
                });
                pSwing.setScale(0.7);
                pSwing.setOffset(0.0, zoomButtonNode.getFullBounds().getMaxY());
                ((PNode)zoomButtonNode2).setOffset(0.0, pSwing.getFullBounds().getMaxY());
                this.addChild(zoomButtonNode);
                this.addChild(pSwing);
                this.addChild(zoomButtonNode2);
                this.setOffset(10.0, 10.0);
            }
        };
    }

    private void addChild(PNode pNode) {
        this.rootNode.addChild(pNode);
    }
}

