/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.gravityandorbits.view;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.RichSimpleObserver;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.gravityandorbits.model.Body;
import edu.colorado.phet.gravityandorbits.view.VectorNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.Dimension2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrabbableVectorNode
extends VectorNode {
    private PhetPPath grabArea;

    public GrabbableVectorNode(final Body body, final Property<ModelViewTransform> property, BooleanProperty booleanProperty, Property<ImmutableVector2D> property2, final double d, Color color, Color color2, final String string) {
        super(body, property, booleanProperty, property2, d, color, color2);
        final Point2D point2D = this.getTip();
        this.grabArea = new PhetPPath(new Ellipse2D.Double(0.0, 0.0, 40.0, 40.0), new Color(0, 0, 0, 0), new BasicStroke(3.0f), Color.lightGray){
            {
                super(shape, paint, stroke, paint2);
                final 1 var8_8 = this;
                this.addChild(new PText(string){
                    {
                        super(string);
                        this.setFont(new PhetFont(28, true));
                        this.setTextPaint(Color.gray);
                        this.setOffset(var8_8.getFullBounds().getWidth() / 2.0 - this.getFullBounds().getWidth() / 2.0, var8_8.getFullBounds().getHeight() / 2.0 - this.getFullBounds().getHeight() / 2.0);
                    }
                });
                this.setOffset(point2D.getX() - this.getFullBounds().getWidth() / 2.0, point2D.getY() - this.getFullBounds().getHeight() / 2.0);
            }
        };
        this.addChild(this.grabArea);
        new RichSimpleObserver(){

            public void update() {
                GrabbableVectorNode.this.grabArea.setOffset(GrabbableVectorNode.this.getTip().getX() - GrabbableVectorNode.this.grabArea.getFullBounds().getWidth() / 2.0, GrabbableVectorNode.this.getTip().getY() - GrabbableVectorNode.this.grabArea.getFullBounds().getHeight() / 2.0);
            }
        }.observe(property2, body.getPositionProperty(), property);
        this.grabArea.addInputEventListener(new PBasicInputEventHandler(){

            public void mouseDragged(PInputEvent pInputEvent) {
                PDimension pDimension = pInputEvent.getDeltaRelativeTo(GrabbableVectorNode.this.getParent());
                Dimension2D dimension2D = ((ModelViewTransform)property.get()).viewToModelDelta(pDimension);
                Point2D.Double double_ = new Point2D.Double(dimension2D.getWidth(), dimension2D.getHeight());
                body.setVelocity(body.getVelocity().getAddedInstance(((Point2D)double_).getX() / d, ((Point2D)double_).getY() / d));
                body.notifyUserModifiedVelocity();
            }
        });
        this.grabArea.addInputEventListener(new CursorHandler());
        this.grabArea.moveToBack();
    }
}

