/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.gravityandorbits.view;

import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.RichSimpleObserver;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.Function1;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.gravityandorbits.model.Body;
import edu.colorado.phet.gravityandorbits.view.BodyRenderer;
import edu.colorado.phet.gravityandorbits.view.IBodyColors;
import edu.umd.cs.piccolo.PNode;
import java.awt.Color;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExplosionNode
extends PNode {
    public ExplosionNode(final Body body, final Property<ModelViewTransform> property) {
        Function1<Integer, Double> function1 = new Function1<Integer, Double>(){

            @Override
            public Double apply(Integer n) {
                if (n < 5) {
                    return new Function.LinearFunction(0.0, 5.0, 1.0, ExplosionNode.this.getMaxViewDiameter(body, property)).evaluate(n.intValue());
                }
                if (n < 10) {
                    return new Function.LinearFunction(5.0, 10.0, ExplosionNode.this.getMaxViewDiameter(body, property), 1.0).evaluate(n.intValue());
                }
                return 1.0;
            }
        };
        this.addChild(this.getExplosionEdgeGraphic(body, function1));
        body.getPositionProperty().addObserver(new SimpleObserver(){

            public void update() {
                ExplosionNode.this.setOffset(((ModelViewTransform)property.get()).modelToView(body.getPosition()).toPoint2D());
            }
        });
    }

    private BodyRenderer.SunRenderer getExplosionEdgeGraphic(final Body body, final Function1<Integer, Double> function1) {
        IBodyColors iBodyColors = new IBodyColors(){

            public Color getHighlight() {
                return Color.white;
            }

            public Color getColor() {
                return Color.yellow;
            }
        };
        Function1<Double, Double> function12 = new Function1<Double, Double>(){

            @Override
            public Double apply(Double d) {
                return d * 2.0;
            }
        };
        return new BodyRenderer.SunRenderer(iBodyColors, 1.0, 14, function12){
            {
                super(iBodyColors, d, n, function13);
                new RichSimpleObserver(){

                    public void update() {
                        this.setVisible(body.getCollidedProperty().get() != false && body.getClockTicksSinceExplosion().get() <= 10);
                    }
                }.observe(body.getCollidedProperty(), body.getClockTicksSinceExplosion());
                body.getClockTicksSinceExplosion().addObserver(new SimpleObserver(){

                    public void update() {
                        this.setDiameter((Double)function1.apply(body.getClockTicksSinceExplosion().get()));
                    }
                });
            }
        };
    }

    private double getMaxViewDiameter(Body body, Property<ModelViewTransform> property) {
        return property.get().modelToViewDeltaX(body.getDiameter()) * 2.0;
    }
}

