/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.gravityandorbits.view;

import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.gravityandorbits.GAOStrings;
import edu.colorado.phet.gravityandorbits.view.BodyNode;
import edu.colorado.phet.gravityandorbits.view.MassReadoutNode;
import java.text.DecimalFormat;
import java.text.MessageFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EarthMassReadoutNode
extends MassReadoutNode {
    public EarthMassReadoutNode(BodyNode bodyNode, Property<Boolean> property) {
        super(bodyNode, property);
    }

    @Override
    protected String createText() {
        String string;
        String string2;
        double d = this.bodyNode.getBody().getMass();
        double d2 = d / 5.9736E24;
        if (d2 > 1000.0) {
            string2 = new DecimalFormat("0").format(Math.round(d2 / 1000.0));
            string = GAOStrings.THOUSAND_EARTH_MASSES;
        } else if (Math.abs(d2 - 1.0) < 0.01) {
            string2 = "1";
            string = GAOStrings.EARTH_MASS;
        } else if (d2 < 1.0) {
            string2 = new DecimalFormat("0.00").format(d2);
            string = GAOStrings.EARTH_MASSES;
        } else {
            string2 = new DecimalFormat("0.00").format(d2);
            string = d2 == 1.0 ? GAOStrings.EARTH_MASS : GAOStrings.EARTH_MASSES;
        }
        return MessageFormat.format(GAOStrings.PATTERN_VALUE_UNITS, string2, string);
    }
}

