/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.gravityandorbits.view;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.util.PhetUtilities;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.Function1;
import edu.colorado.phet.common.phetcommon.view.graphics.RoundGradientPaint;
import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.nodes.SphericalNode;
import edu.colorado.phet.gravityandorbits.GravityAndOrbitsApplication;
import edu.colorado.phet.gravityandorbits.model.Body;
import edu.colorado.phet.gravityandorbits.view.IBodyColors;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

public abstract class BodyRenderer
extends PNode {
    private IBodyColors body;

    public BodyRenderer(IBodyColors iBodyColors) {
        this.body = iBodyColors;
    }

    public IBodyColors getBody() {
        return this.body;
    }

    public abstract void setDiameter(double var1);

    public static class ImageRenderer
    extends BodyRenderer {
        private final PImage imageNode;
        private double viewDiameter;

        public ImageRenderer(IBodyColors iBodyColors, double d, String string) {
            super(iBodyColors);
            this.imageNode = new PImage(GravityAndOrbitsApplication.RESOURCES.getImage(string));
            this.addChild(this.imageNode);
            this.viewDiameter = d;
            this.updateViewDiameter();
        }

        public void setDiameter(double d) {
            this.viewDiameter = d;
            this.updateViewDiameter();
        }

        private void updateViewDiameter() {
            this.imageNode.setTransform(new AffineTransform());
            double d = this.viewDiameter / this.imageNode.getFullBounds().getWidth();
            this.imageNode.setScale(d);
            this.imageNode.translate(-this.imageNode.getFullBounds().getWidth() / 2.0 / d, -this.imageNode.getFullBounds().getHeight() / 2.0 / d);
        }
    }

    public static class SphereRenderer
    extends BodyRenderer {
        private SphericalNode sphereNode;

        public SphereRenderer(final Color color, final Color color2, double d) {
            this(new IBodyColors(){

                public Color getHighlight() {
                    return color2;
                }

                public Color getColor() {
                    return color;
                }
            }, d);
        }

        public SphereRenderer(IBodyColors iBodyColors, double d) {
            super(iBodyColors);
            this.sphereNode = new SphericalNode(d, this.createPaint(d), true);
            this.addChild(this.sphereNode);
        }

        public void setDiameter(double d) {
            this.sphereNode.setDiameter(d);
            this.sphereNode.setPaint(this.createPaint(d));
        }

        private Paint createPaint(double d) {
            if (PhetUtilities.isMacintosh()) {
                return this.getBody().getColor();
            }
            return new RoundGradientPaint(d / 8.0, -d / 8.0, this.getBody().getHighlight(), new Point2D.Double(d / 4.0, d / 4.0), this.getBody().getColor());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SunRenderer
    extends SphereRenderer {
        private final PhetPPath twinkles = new PhetPPath(Color.yellow);
        private final int numSegments;
        private final Function1<Double, Double> twinkleRadius;

        public SunRenderer(IBodyColors iBodyColors, double d, int n, Function1<Double, Double> function1) {
            super(iBodyColors, d);
            this.numSegments = n;
            this.twinkleRadius = function1;
            this.addChild(this.twinkles);
            this.twinkles.moveToBack();
            this.setDiameter(d);
        }

        @Override
        public void setDiameter(double d) {
            super.setDiameter(d);
            double d2 = 0.0;
            double d3 = Math.PI * 2 / (double)this.numSegments;
            double d4 = d / 2.0;
            DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath();
            doubleGeneralPath.moveTo(0.0, 0.0);
            for (int i = 0; i < this.numSegments + 1; ++i) {
                double d5 = i % 2 == 0 ? this.twinkleRadius.apply(d4) : d4;
                ImmutableVector2D immutableVector2D = ImmutableVector2D.parseAngleAndMagnitude(d5, d2);
                doubleGeneralPath.lineTo(immutableVector2D);
                d2 += d3;
            }
            this.twinkles.setPathTo(doubleGeneralPath.getGeneralPath());
        }
    }

    public static class SwitchableBodyRenderer
    extends BodyRenderer {
        private final BodyRenderer targetBodyRenderer;
        private final BodyRenderer defaultBodyRenderer;

        public SwitchableBodyRenderer(final Body body, final double d, final BodyRenderer bodyRenderer, final BodyRenderer bodyRenderer2) {
            super(body);
            this.targetBodyRenderer = bodyRenderer;
            this.defaultBodyRenderer = bodyRenderer2;
            body.getMassProperty().addObserver(new SimpleObserver(){

                public void update() {
                    SwitchableBodyRenderer.this.removeAllChildren();
                    SwitchableBodyRenderer.this.addChild(body.getMass() == d ? bodyRenderer : bodyRenderer2);
                }
            });
        }

        public void setDiameter(double d) {
            this.targetBodyRenderer.setDiameter(d);
            this.defaultBodyRenderer.setDiameter(d);
        }
    }
}

