/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.gravityandorbits.view;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.RichSimpleObserver;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.ArrowNode;
import edu.colorado.phet.gravityandorbits.model.Body;
import edu.colorado.phet.gravityandorbits.view.BodyRenderer;
import edu.umd.cs.piccolo.PComponent;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.Color;
import java.awt.Image;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BodyNode
extends PNode {
    private final Property<ModelViewTransform> modelViewTransform;
    private final Body body;
    private final Property<Boolean> whiteBackgroundProperty;
    private final BodyRenderer bodyRenderer;

    public BodyNode(final Body body, final Property<ModelViewTransform> property, final Property<ImmutableVector2D> property2, final PComponent pComponent, double d, Property<Boolean> property3) {
        this.modelViewTransform = property;
        this.body = body;
        this.whiteBackgroundProperty = property3;
        body.getCollidedProperty().addObserver(new SimpleObserver(){

            public void update() {
                BodyNode.this.setVisible(body.getCollidedProperty().get() == false);
            }
        });
        this.bodyRenderer = body.createRenderer(this.getViewDiameter());
        this.addChild(this.bodyRenderer);
        final CursorHandler cursorHandler = new CursorHandler();
        this.addInputEventListener(cursorHandler);
        this.addInputEventListener(new PBasicInputEventHandler(){

            public void mousePressed(PInputEvent pInputEvent) {
                body.setUserControlled(true);
            }

            public void mouseDragged(PInputEvent pInputEvent) {
                Dimension2D dimension2D = ((ModelViewTransform)property.get()).viewToModelDelta(pInputEvent.getDeltaRelativeTo(BodyNode.this.getParent()));
                body.translate(new Point2D.Double(dimension2D.getWidth(), dimension2D.getHeight()));
                body.notifyUserModifiedPosition();
            }

            public void mouseReleased(PInputEvent pInputEvent) {
                body.setUserControlled(false);
            }
        });
        new RichSimpleObserver(){

            public void update() {
                boolean bl = BodyNode.this.bodyRenderer.getGlobalFullBounds().contains(((ImmutableVector2D)property2.get()).toPoint2D());
                BodyNode.this.setOffset(BodyNode.this.getPosition(property, body).toPoint2D());
                boolean bl2 = BodyNode.this.bodyRenderer.getGlobalFullBounds().contains(((ImmutableVector2D)property2.get()).toPoint2D());
                if (pComponent != null) {
                    if (bl && !bl2) {
                        cursorHandler.mouseExited(new PInputEvent(null, null){

                            public PComponent getComponent() {
                                return pComponent;
                            }
                        });
                    }
                    if (!bl && bl2) {
                        cursorHandler.mouseEntered(new PInputEvent(null, null){

                            public PComponent getComponent() {
                                return pComponent;
                            }
                        });
                    }
                }
            }
        }.observe(body.getPositionProperty(), property);
        new RichSimpleObserver(){

            public void update() {
                BodyNode.this.bodyRenderer.setDiameter(BodyNode.this.getViewDiameter());
            }
        }.observe(body.getDiameterProperty(), property);
        this.addChild(this.createArrowIndicator(body, d));
    }

    private PNode createArrowIndicator(final Body body, final double d) {
        return new PNode(){
            {
                Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
                ImmutableVector2D immutableVector2D = ImmutableVector2D.parseAngleAndMagnitude(1.0, d);
                Point2D.Double double_2 = immutableVector2D.getScaledInstance(10.0).getDestination(double_);
                final Point2D.Double double_3 = immutableVector2D.getScaledInstance(50.0).getDestination(double_);
                this.addChild(new ArrowNode(double_3, double_2, 0.0, 0.0, 3.0){
                    {
                        this.setPaint(Color.yellow);
                    }
                });
                this.addChild(new PText(body.getName()){
                    {
                        super(string);
                        this.setOffset(double_3.getX() - this.getFullBounds().getWidth() / 2.0 - 5.0, double_3.getY() - this.getFullBounds().getHeight() - 10.0);
                        BodyNode.this.whiteBackgroundProperty.addObserver(new VoidFunction1<Boolean>(){

                            @Override
                            public void apply(Boolean bl) {
                                this.setTextPaint(bl != false ? Color.black : Color.white);
                            }
                        });
                        this.setFont(new PhetFont(18, true));
                    }
                });
                PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        this.setVisible(BodyNode.this.bodyRenderer.getGlobalFullBounds().getWidth() <= 10.0);
                    }
                };
                BodyNode.this.bodyRenderer.addPropertyChangeListener("fullBounds", propertyChangeListener);
                propertyChangeListener.propertyChange(null);
            }
        };
    }

    private ImmutableVector2D getPosition(Property<ModelViewTransform> property, Body body) {
        return property.get().modelToView(body.getPosition());
    }

    private double getViewDiameter() {
        double d = this.modelViewTransform.get().modelToViewDeltaX(this.body.getDiameter());
        return Math.max(d, 2.0);
    }

    public Image renderImage(int n) {
        return this.body.createRenderer(n).toImage(n, n, new Color(0, 0, 0, 0));
    }

    public Body getBody() {
        return this.body;
    }

    public BodyRenderer getBodyRenderer() {
        return this.bodyRenderer;
    }
}

