/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.gravityandorbits.simsharing;

import edu.colorado.phet.common.phetcommon.util.IProguardKeepClass;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;

public class SerializableBufferedImage
implements IProguardKeepClass {
    private byte[] byteImage = null;

    public SerializableBufferedImage() {
    }

    public SerializableBufferedImage(BufferedImage bufferedImage) {
        this.byteImage = SerializableBufferedImage.toByteArray(bufferedImage, "JPG");
    }

    public byte[] getByteImage() {
        return this.byteImage;
    }

    public BufferedImage toBufferedImage() {
        return SerializableBufferedImage.fromByteArray(this.byteImage);
    }

    public static BufferedImage fromByteArray(byte[] byArray) {
        try {
            if (byArray != null && byArray.length > 0) {
                BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(byArray));
                return bufferedImage;
            }
            return null;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException.toString());
        }
    }

    private static byte[] toByteArray(BufferedImage bufferedImage, String string) {
        if (bufferedImage != null) {
            BufferedImage bufferedImage2 = bufferedImage;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                ImageIO.write((RenderedImage)bufferedImage2, string, byteArrayOutputStream);
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException.toString());
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        return new byte[0];
    }
}

